/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import potionstudios.byg.BYG;
import potionstudios.byg.common.block.sapling.GrowingPatterns;
import potionstudios.byg.util.BYGUtil;

public interface FeatureGrowerFromBlockPattern {
    public static final List<Supplier<? extends FeatureGrowerFromBlockPattern>> ENTRIES = new ArrayList<Supplier<? extends FeatureGrowerFromBlockPattern>>();

    default public void load(Block block) {
        this.serializePatterns(block);
    }

    public ImmutableList<Pair<List<Vec3i>, SimpleWeightedRandomList<GrowingPatterns.FeatureSpawner>>> byg_getPatterns();

    public void byg_setPatterns(ImmutableList<Pair<List<Vec3i>, SimpleWeightedRandomList<GrowingPatterns.FeatureSpawner>>> var1);

    default public void serializePatterns(Block key) {
        ArrayList list = new ArrayList();
        GrowingPatterns.getConfig().getPatterns(key).map(ArrayList::new).ifPresent(growingPatternEntries -> {
            growingPatternEntries.sort(Comparator.comparingInt(p -> {
                int saplingCount = 0;
                for (String s : p.pattern()) {
                    char[] chars;
                    for (char aChar : chars = s.toCharArray()) {
                        if (aChar != 'x' && aChar != 'X') continue;
                        ++saplingCount;
                    }
                }
                return saplingCount;
            }));
            for (GrowingPatterns.GrowingPatternEntry growingPatternEntry : growingPatternEntries) {
                List<String> pattern = growingPatternEntry.pattern();
                ArrayList<Vec3i> offsets = new ArrayList<Vec3i>();
                int patternLoopSize = Math.min(pattern.size(), 5);
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < patternLoopSize; ++i) {
                    String s = pattern.get(i);
                    String substring = s.substring(0, Math.min(s.length(), 5));
                    builder.append(substring);
                }
                String patternCombined = builder.toString();
                String trimmed = patternCombined.trim();
                if (trimmed.length() > 1) {
                    int zOffset = -patternLoopSize / 2;
                    for (int i = 0; i < patternLoopSize; ++i) {
                        char[] charArray;
                        String s = pattern.get(i);
                        int range = Math.min(s.length(), 5);
                        String substring = s.substring(0, range);
                        int xOffset = -range / 2;
                        for (char c : charArray = substring.toCharArray()) {
                            if (c == 'x' || c == 'X') {
                                offsets.add(new Vec3i(xOffset, 0, zOffset));
                            }
                            ++xOffset;
                        }
                        ++zOffset;
                    }
                } else {
                    offsets.add(Vec3i.f_123288_);
                }
                list.add(Pair.of(offsets, growingPatternEntry.spawners()));
            }
        });
        Collections.reverse(list);
        this.byg_setPatterns((ImmutableList<Pair<List<Vec3i>, SimpleWeightedRandomList<GrowingPatterns.FeatureSpawner>>>)ImmutableList.copyOf(list));
    }

    default public boolean growFeature(Block block, ServerLevel level, BlockPos pos, RandomSource rand) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
        int range = 2;
        for (Pair entry : this.byg_getPatterns()) {
            for (int xMove = -range; xMove <= range; ++xMove) {
                for (int zMove = -range; zMove <= range; ++zMove) {
                    String blockID;
                    Optional configuredFeaturesOptionalRegistry;
                    BlockPos.MutableBlockPos mutableBlockPos1 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutableBlockPos.m_122190_((Vec3i)pos).m_122184_(xMove, 0, zMove));
                    List offsets = (List)entry.getFirst();
                    SimpleWeightedRandomList treePicker = (SimpleWeightedRandomList)entry.getSecond();
                    boolean matchedPattern = FeatureGrowerFromBlockPattern.patternMatches(level, offsets, mutableBlockPos1, (BlockPos)mutableBlockPos, block, false);
                    boolean rotated = false;
                    if (!matchedPattern && FeatureGrowerFromBlockPattern.patternMatches(level, offsets, mutableBlockPos1, (BlockPos)mutableBlockPos, block, true)) {
                        matchedPattern = true;
                        rotated = true;
                    }
                    if (!matchedPattern || !(configuredFeaturesOptionalRegistry = level.m_5962_().m_142664_(Registry.f_122881_)).isPresent()) continue;
                    Registry configuredFeaturesRegistry = (Registry)configuredFeaturesOptionalRegistry.get();
                    Optional randomValue = treePicker.m_216820_(rand);
                    if (!randomValue.isPresent()) continue;
                    GrowingPatterns.FeatureSpawner featureSpawner = (GrowingPatterns.FeatureSpawner)randomValue.get();
                    ConfiguredFeature configuredFeature = (ConfiguredFeature)configuredFeaturesRegistry.m_6246_(featureSpawner.spawnerID());
                    ResourceLocation blockKey = Registry.f_122824_.m_7981_((Object)block);
                    String string = blockID = blockKey == null ? "unknown_grower_block" : blockKey.toString();
                    if (configuredFeature != null) {
                        Vec3i spawnOffset = featureSpawner.spawnOffset();
                        BlockPos growthPos = mutableBlockPos1.m_121955_(spawnOffset);
                        if (configuredFeature.m_224953_((WorldGenLevel)level, level.m_7726_().m_8481_(), rand, growthPos.m_7949_())) {
                            for (Vec3i offset : offsets) {
                                BlockPos.MutableBlockPos movedPos;
                                BlockState offsetState;
                                if (rotated) {
                                    offset = new Vec3i(offset.m_123343_(), offset.m_123342_(), offset.m_123341_());
                                }
                                if (!(offsetState = level.m_8055_((BlockPos)(movedPos = mutableBlockPos1.m_122190_((Vec3i)mutableBlockPos).m_122193_(offset)))).m_60713_(block)) continue;
                                level.m_7471_((BlockPos)movedPos, false);
                            }
                            if (GrowingPatterns.getConfig().logGrowth()) {
                                BYG.logInfo(String.format("Grower \"%s\" grew configured feature \"%s\" at position %s(growth offset: %s).", blockID, featureSpawner.toString(), growthPos, spawnOffset));
                            }
                            return true;
                        }
                        if (!GrowingPatterns.getConfig().logGrowth()) continue;
                        BYG.logInfo(String.format("Grower \"%s\" couldn't grow configured feature \"%s\" at position %s(growth offset: %s).", blockID, featureSpawner.toString(), growthPos, spawnOffset));
                        continue;
                    }
                    BYG.logError(String.format("Grower \"%s\" failed when attempting to spawn configured feature \"%s\" at position %s. \"%s\" is not a valid configured feature ID in this world's datapack configured feature registry! Valid entries:\n %s", blockID, featureSpawner, pos, featureSpawner, BYGUtil.dumpRegistry(configuredFeaturesRegistry)));
                }
            }
        }
        return false;
    }

    public static boolean patternMatches(ServerLevel level, List<Vec3i> offsets, BlockPos.MutableBlockPos mutableBlockPos, BlockPos pos, Block block, boolean rotated) {
        for (Vec3i offset : offsets) {
            if (rotated) {
                offset = new Vec3i(offset.m_123343_(), offset.m_123342_(), offset.m_123341_());
            }
            mutableBlockPos.m_122190_((Vec3i)pos).m_122193_(offset);
            BlockState offsetState = level.m_8055_((BlockPos)mutableBlockPos);
            if (offsetState.m_60713_(block)) continue;
            return false;
        }
        return true;
    }
}

