/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import thelm.packagedauto.client.screen.BaseScreen;
import thelm.packagedauto.menu.BaseMenu;

public abstract class AmountSpecifyingScreen<C extends BaseMenu<?>>
extends BaseScreen<C> {
    private BaseScreen<?> parent;
    protected EditBox amountField;

    public AmountSpecifyingScreen(BaseScreen<?> parent, C menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.parent = parent;
    }

    protected abstract int getDefaultAmount();

    protected abstract int getMaxAmount();

    protected abstract int[] getIncrements();

    protected void m_7856_() {
        String text;
        int increment;
        int i;
        this.m_169413_();
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ButtonSet(this.f_97735_ + 114, this.f_97736_ + 22, (Component)Component.m_237115_((String)"misc.packagedauto.set")));
        this.m_142416_((GuiEventListener)new ButtonCancel(this.f_97735_ + 114, this.f_97736_ + 22 + 24, (Component)Component.m_237115_((String)"gui.cancel")));
        Objects.requireNonNull(this.f_96547_);
        this.amountField = new EditBox(this.f_96547_, this.f_97735_ + 9, this.f_97736_ + 51, 63, 9, (Component)Component.m_237119_());
        this.amountField.m_94182_(false);
        this.amountField.m_94144_(String.valueOf(this.getDefaultAmount()));
        this.amountField.m_94202_(0xFFFFFF);
        this.amountField.m_94153_(s -> {
            if (s.isEmpty()) {
                return true;
            }
            try {
                int amount = Integer.parseInt(s);
                return amount >= 0 && amount <= this.getMaxAmount();
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        this.amountField.m_5755_(true);
        this.m_142416_((GuiEventListener)this.amountField);
        this.m_7522_((GuiEventListener)this.amountField);
        int[] increments = this.getIncrements();
        int xx = 7;
        int width = 34;
        for (i = 0; i < 3; ++i) {
            increment = increments[i];
            text = "+" + increment;
            this.m_142416_((GuiEventListener)new ButtonIncrement(increment, this.f_97735_ + xx, this.f_97736_ + 20, (Component)Component.m_237113_((String)text)));
            xx += width;
        }
        xx = 7;
        for (i = 0; i < 3; ++i) {
            increment = increments[i];
            text = "-" + increment;
            this.m_142416_((GuiEventListener)new ButtonIncrement(-increment, this.f_97735_ + xx, this.f_97736_ + this.f_97727_ - 20 - 7, (Component)Component.m_237113_((String)text)));
            xx += width;
        }
    }

    @Override
    protected void renderBgAdditional(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.amountField.m_6303_(poseStack, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        this.f_96547_.m_92883_(poseStack, this.m_96636_().getString(), 7.0f, 7.0f, 0x404040);
        super.m_7027_(poseStack, mouseX, mouseY);
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.close();
            return true;
        }
        if ((key == 257 || key == 335) && this.amountField.m_93696_()) {
            this.onOkButtonPressed(AmountSpecifyingScreen.m_96638_());
            return true;
        }
        if (this.amountField.m_7933_(key, scanCode, modifiers)) {
            return true;
        }
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)key, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.amountField.m_93696_()) {
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    private void onIncrementButtonClicked(int increment) {
        int oldAmount = 0;
        try {
            oldAmount = Integer.parseInt(this.amountField.m_94155_());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int newAmount = Mth.m_14045_((int)(oldAmount + increment), (int)0, (int)this.getMaxAmount());
        this.amountField.m_94144_(String.valueOf(newAmount));
    }

    protected abstract void onOkButtonPressed(boolean var1);

    public void close() {
        this.f_96541_.m_91152_(this.parent);
    }

    public BaseScreen<?> getParent() {
        return this.parent;
    }

    class ButtonSet
    extends AbstractWidget {
        public ButtonSet(int x, int y, Component text) {
            super(x, y, 50, 20, text);
        }

        public void m_5716_(double mouseX, double mouseY) {
            AmountSpecifyingScreen.this.onOkButtonPressed(Screen.m_96638_());
        }

        public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
        }
    }

    class ButtonCancel
    extends AbstractWidget {
        public ButtonCancel(int x, int y, Component text) {
            super(x, y, 50, 20, text);
        }

        public void m_5716_(double mouseX, double mouseY) {
            AmountSpecifyingScreen.this.close();
        }

        public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
        }
    }

    class ButtonIncrement
    extends AbstractWidget {
        int increment;

        public ButtonIncrement(int increment, int x, int y, Component text) {
            super(x, y, 34, 20, text);
            this.increment = increment;
        }

        public void m_5716_(double mouseX, double mouseY) {
            AmountSpecifyingScreen.this.onIncrementButtonClicked(this.increment);
        }

        public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
        }
    }
}

