/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.recipe;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.integration.appeng.AppEngUtil;

public class RecipeCraftingPatternDetails
implements IPatternDetails {
    public final AEItemKey recipeHolder;
    public final IPackageRecipeInfo recipe;
    public final GenericStack[] sparseInputs;
    public final GenericStack[] sparseOutputs;
    public final IPatternDetails.IInput[] inputs;
    public final GenericStack[] outputs;
    private int priority = 0;

    public RecipeCraftingPatternDetails(ItemStack recipeHolder, IPackageRecipeInfo recipe) {
        this.recipeHolder = AEItemKey.of((ItemStack)recipeHolder);
        this.recipe = recipe;
        this.sparseInputs = (GenericStack[])recipe.getPatterns().stream().map(IPackagePattern::getOutput).map(GenericStack::fromItemStack).toArray(GenericStack[]::new);
        this.sparseOutputs = (GenericStack[])recipe.getOutputs().stream().map(this::getGenericOutput).toArray(GenericStack[]::new);
        this.inputs = AppEngUtil.toInputs(this.sparseInputs);
        this.outputs = AppEngUtil.condenseStacks(this.sparseOutputs);
    }

    public AEItemKey getDefinition() {
        return this.recipeHolder;
    }

    public GenericStack[] getSparseInputs() {
        return this.sparseInputs;
    }

    public GenericStack[] getSparseOutputs() {
        return this.sparseOutputs;
    }

    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    public GenericStack[] getOutputs() {
        return this.outputs;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecipeCraftingPatternDetails) {
            RecipeCraftingPatternDetails other = (RecipeCraftingPatternDetails)obj;
            return this.recipe.equals(other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return this.recipe.hashCode();
    }

    private GenericStack getGenericOutput(ItemStack stack) {
        AEKey key;
        IVolumePackageItem vPackage;
        IVolumeStackWrapper vStack;
        Item item = stack.m_41720_();
        if (item instanceof IVolumePackageItem && !(vStack = (vPackage = (IVolumePackageItem)item).getVolumeStack(stack)).isEmpty() && vStack.getVolumeType() != null && vStack.getVolumeType().supportsAE() && (key = AEKey.fromTagGeneric((CompoundTag)vStack.saveAEKey(new CompoundTag()))) != null) {
            return new GenericStack(key, (long)(vStack.getAmount() * stack.m_41613_()));
        }
        return GenericStack.fromItemStack((ItemStack)stack);
    }
}

