/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import thelm.packagedauto.client.screen.EncoderScreen;
import thelm.packagedauto.integration.jei.EncoderGhostIngredientHandler;
import thelm.packagedauto.integration.jei.EncoderGuiHandler;
import thelm.packagedauto.integration.jei.EncoderTransferHandler;

@JeiPlugin
public class PackagedAutoJEIPlugin
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("packagedauto:jei");
    public static IJeiRuntime jeiRuntime;
    public static List<ResourceLocation> allCategories;

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addUniversalRecipeTransferHandler((IRecipeTransferHandler)new EncoderTransferHandler(registration.getTransferHelper()));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(EncoderScreen.class, (IGuiContainerHandler)new EncoderGuiHandler());
        registration.addGhostIngredientHandler(EncoderScreen.class, (IGhostIngredientHandler)new EncoderGhostIngredientHandler());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        PackagedAutoJEIPlugin.jeiRuntime = jeiRuntime;
        allCategories = jeiRuntime.getRecipeManager().createRecipeCategoryLookup().get().map(c -> c.getRecipeType().getUid()).toList();
    }

    public static List<ResourceLocation> getAllRecipeCategories() {
        return allCategories;
    }

    static {
        allCategories = List.of();
    }
}

