/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.menu;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.slot.FalseCopySlot;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.OptionalIntDataSlot;

public class BaseMenu<T extends BaseBlockEntity>
extends AbstractContainerMenu {
    public final T blockEntity;
    public final Inventory inventory;
    public final BaseItemHandler<?> itemHandler;

    public BaseMenu(MenuType<?> menuType, int windowId, Inventory inventory, T blockEntity) {
        super(menuType, windowId);
        this.blockEntity = blockEntity;
        this.inventory = inventory;
        this.itemHandler = blockEntity != null ? ((BaseBlockEntity)((Object)blockEntity)).getItemHandler() : new BaseItemHandler<Object>(null, 0);
        this.m_38884_(this.itemHandler);
    }

    public int getPlayerInvY() {
        return 84;
    }

    public int getPlayerInvX() {
        return 8;
    }

    public void setupPlayerInventory() {
        int i;
        int xOffset = this.getPlayerInvX();
        int yOffset = this.getPlayerInvY();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.inventory, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.inventory, i, xOffset + i * 18, yOffset + 58));
        }
    }

    protected void m_38884_(ContainerData array) {
        for (int i = 0; i < array.m_6499_(); ++i) {
            this.m_38895_(OptionalIntDataSlot.of(array, i));
        }
    }

    public int getSizeInventory() {
        return this.itemHandler.getSlots();
    }

    public boolean supportsShiftClick(Player player, int slotIndex) {
        return true;
    }

    public boolean performMerge(Player player, int slotIndex, ItemStack stack) {
        int invBase = this.getSizeInventory();
        int invFull = this.f_38839_.size();
        if (slotIndex < invBase) {
            return this.m_38903_(stack, invBase, invFull, true);
        }
        return this.m_38903_(stack, 0, invBase, false);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        if (!this.supportsShiftClick(player, slotIndex)) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            stack = stackInSlot.m_41777_();
            if (!this.performMerge(player, slotIndex, stackInSlot)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(stackInSlot, stack);
            if (stackInSlot.m_41613_() <= 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_5852_(stackInSlot);
            }
            if (stackInSlot.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stackInSlot);
        }
        return stack;
    }

    protected boolean m_38903_(ItemStack stack, int slotMin, int slotMax, boolean ascending) {
        int maxStack;
        int rmv;
        ItemStack existingStack;
        Slot slot;
        int iterOrder;
        boolean successful = false;
        int i = !ascending ? slotMin : slotMax - 1;
        int n = iterOrder = !ascending ? 1 : -1;
        if (stack.m_41753_()) {
            while (stack.m_41613_() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
                slot = (Slot)this.f_38839_.get(i);
                if (slot instanceof FalseCopySlot) {
                    i += iterOrder;
                    continue;
                }
                existingStack = slot.m_7993_();
                if (!existingStack.m_41619_() && slot.m_5857_(MiscHelper.INSTANCE.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.m_41741_(), slot.m_6641_()), stack.m_41613_()))) && ItemStack.m_150942_((ItemStack)stack, (ItemStack)existingStack)) {
                    int existingSize = existingStack.m_41613_() + stack.m_41613_();
                    if (existingSize <= maxStack) {
                        stack.m_41764_(0);
                        existingStack.m_41764_(existingSize);
                        slot.m_5852_(existingStack);
                        successful = true;
                    } else if (existingStack.m_41613_() < maxStack) {
                        stack.m_41774_(maxStack - existingStack.m_41613_());
                        existingStack.m_41764_(maxStack);
                        slot.m_5852_(existingStack);
                        successful = true;
                    }
                }
                i += iterOrder;
            }
        }
        if (stack.m_41613_() > 0) {
            int n2 = i = !ascending ? slotMin : slotMax - 1;
            while (stack.m_41613_() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
                slot = (Slot)this.f_38839_.get(i);
                if (slot instanceof FalseCopySlot) {
                    i += iterOrder;
                    continue;
                }
                existingStack = slot.m_7993_();
                if (existingStack.m_41619_() && slot.m_5857_(MiscHelper.INSTANCE.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.m_41741_(), slot.m_6641_()), stack.m_41613_())))) {
                    existingStack = stack.m_41620_(rmv);
                    slot.m_5852_(existingStack);
                    successful = true;
                }
                i += iterOrder;
            }
        }
        return successful;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_150399_(int slotId, int mouseButton, ClickType clickType, Player player) {
        block7: {
            Slot slot;
            Slot slot2 = slot = slotId < 0 ? null : (Slot)this.f_38839_.get(slotId);
            if (!(slot instanceof FalseCopySlot)) break block7;
            ItemStack stack = slot.m_7993_().m_41777_();
            switch (mouseButton) {
                case 0: {
                    slot.m_5852_(this.m_142621_().m_41619_() ? ItemStack.f_41583_ : this.m_142621_().m_41777_());
                    break;
                }
                case 1: {
                    if (!this.m_142621_().m_41619_()) {
                        ItemStack toPut = this.m_142621_().m_41777_();
                        if (ItemStack.m_150942_((ItemStack)stack, (ItemStack)toPut) && stack.m_41613_() < stack.m_41741_()) {
                            stack.m_41769_(1);
                            slot.m_5852_(stack);
                            break;
                        }
                        toPut.m_41764_(1);
                        slot.m_5852_(toPut);
                        break;
                    }
                    if (stack.m_41619_()) break;
                    stack.m_41774_(1);
                    slot.m_5852_(stack);
                    break;
                }
                case 2: {
                    if (player.m_7500_()) break block7;
                    if (stack.m_41619_() || stack.m_41613_() >= stack.m_41741_()) break;
                    stack.m_41769_(1);
                    slot.m_5852_(stack);
                }
            }
            return;
        }
        super.m_150399_(slotId, mouseButton, clickType, player);
    }

    public boolean m_6875_(Player player) {
        return true;
    }
}

