/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkEvent;
import thelm.packagedauto.slot.FalseCopySlot;

public class SetItemStackPacket {
    private short containerSlot;
    private ItemStack stack;

    public SetItemStackPacket(short containerSlot, ItemStack stack) {
        this.containerSlot = containerSlot;
        this.stack = stack;
    }

    public static void encode(SetItemStackPacket pkt, FriendlyByteBuf buf) {
        buf.writeShort((int)pkt.containerSlot);
        buf.m_130055_(pkt.stack);
    }

    public static SetItemStackPacket decode(FriendlyByteBuf buf) {
        return new SetItemStackPacket(buf.readShort(), buf.m_130267_());
    }

    public static void handle(SetItemStackPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        ctx.get().enqueueWork(() -> {
            Slot slot;
            AbstractContainerMenu container = player.f_36096_;
            if (container != null && pkt.containerSlot >= 0 && pkt.containerSlot < container.f_38839_.size() && (slot = container.m_38853_((int)pkt.containerSlot)) instanceof FalseCopySlot) {
                FalseCopySlot fSlot = (FalseCopySlot)slot;
                ItemStackHandler handler = (ItemStackHandler)fSlot.getItemHandler();
                handler.setStackInSlot(slot.getSlotIndex(), pkt.stack);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

