/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import thelm.packagedauto.menu.EncoderMenu;

public class SetRecipePacket {
    private Int2ObjectMap<ItemStack> map;

    public SetRecipePacket(Int2ObjectMap<ItemStack> map) {
        this.map = map;
    }

    public SetRecipePacket addItem(int index, ItemStack stack) {
        this.map.put(index, (Object)stack);
        return this;
    }

    public static void encode(SetRecipePacket pkt, FriendlyByteBuf buf) {
        buf.writeByte(pkt.map.size());
        for (Int2ObjectMap.Entry entry : pkt.map.int2ObjectEntrySet()) {
            buf.writeByte(entry.getIntKey());
            buf.m_130055_((ItemStack)entry.getValue());
        }
    }

    public static SetRecipePacket decode(FriendlyByteBuf buf) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int size = buf.readByte();
        for (int i = 0; i < size; ++i) {
            byte index = buf.readByte();
            ItemStack stack = buf.m_130267_();
            map.put((int)index, (Object)stack);
        }
        return new SetRecipePacket((Int2ObjectMap<ItemStack>)map);
    }

    public static void handle(SetRecipePacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        ctx.get().enqueueWork(() -> {
            AbstractContainerMenu patt1497$temp = player.f_36096_;
            if (patt1497$temp instanceof EncoderMenu) {
                EncoderMenu menu = (EncoderMenu)patt1497$temp;
                menu.patternItemHandler.setRecipe(pkt.map);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

