/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.recipe.OrderedProcessingPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;

public class OrderedProcessingPackageRecipeInfo
implements IPackageRecipeInfo {
    List<ItemStack> input = new ArrayList<ItemStack>();
    List<ItemStack> output = new ArrayList<ItemStack>();
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    @Override
    public void load(CompoundTag nbt) {
        MiscHelper.INSTANCE.loadAllItems(nbt.m_128437_("Input", 10), this.input);
        MiscHelper.INSTANCE.loadAllItems(nbt.m_128437_("Output", 10), this.output);
        this.patterns.clear();
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PackagePattern(this, i, true));
            ++i;
        }
    }

    @Override
    public void save(CompoundTag nbt) {
        ListTag inputTag = MiscHelper.INSTANCE.saveAllItems(new ListTag(), this.input);
        nbt.m_128365_("Input", (Tag)inputTag);
        ListTag outputTag = MiscHelper.INSTANCE.saveAllItems(new ListTag(), this.output);
        nbt.m_128365_("Output", (Tag)outputTag);
    }

    @Override
    public IPackageRecipeType getRecipeType() {
        return OrderedProcessingPackageRecipeType.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return !this.input.isEmpty();
    }

    @Override
    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public List<ItemStack> getOutputs() {
        return Collections.unmodifiableList(this.output);
    }

    private static List<ItemStack> removeEmptyStacks(List<ItemStack> stacks) {
        return stacks.stream().filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
    }

    @Override
    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, Level level) {
        this.input.clear();
        this.input.addAll(OrderedProcessingPackageRecipeInfo.removeEmptyStacks(input));
        this.output.clear();
        this.output.addAll(OrderedProcessingPackageRecipeInfo.removeEmptyStacks(output));
        this.patterns.clear();
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PackagePattern(this, i, true));
            ++i;
        }
    }

    @Override
    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        int i;
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        for (i = 0; i < this.input.size(); ++i) {
            map.put(i, (Object)this.input.get(i));
        }
        for (i = 0; i < this.output.size(); ++i) {
            map.put(i + 81, (Object)this.output.get(i));
        }
        return map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OrderedProcessingPackageRecipeInfo) {
            int i;
            OrderedProcessingPackageRecipeInfo other = (OrderedProcessingPackageRecipeInfo)obj;
            if (this.input.size() != other.input.size() || this.output.size() != other.output.size()) {
                return false;
            }
            for (i = 0; i < this.input.size(); ++i) {
                if (ItemStack.m_41728_((ItemStack)this.input.get(i), (ItemStack)other.input.get(i))) continue;
                return false;
            }
            for (i = 0; i < this.output.size(); ++i) {
                if (ItemStack.m_41728_((ItemStack)this.output.get(i), (ItemStack)other.output.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        Object[] toHash = new Object[2];
        Object[] inputArray = new Object[this.input.size()];
        for (int i = 0; i < this.input.size(); ++i) {
            ItemStack stack = this.input.get(i);
            inputArray[i] = new Object[]{stack.m_41720_(), stack.m_41613_(), stack.m_41783_()};
        }
        Object[] outputArray = new Object[this.output.size()];
        for (int i = 0; i < this.output.size(); ++i) {
            ItemStack stack = this.output.get(i);
            outputArray[i] = new Object[]{stack.m_41720_(), stack.m_41613_(), stack.m_41783_()};
        }
        toHash[0] = inputArray;
        toHash[1] = outputArray;
        return Arrays.deepHashCode(toHash);
    }
}

