/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fml.ModList;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.api.IRecipeSlotViewWrapper;
import thelm.packagedauto.api.IRecipeSlotsViewWrapper;
import thelm.packagedauto.integration.jei.PackagedAutoJEIPlugin;
import thelm.packagedauto.item.VolumePackageItem;
import thelm.packagedauto.recipe.ProcessingPackageRecipeInfo;
import thelm.packagedauto.util.MiscHelper;

public class ProcessingPackageRecipeType
implements IPackageRecipeType {
    public static final ProcessingPackageRecipeType INSTANCE = new ProcessingPackageRecipeType();
    public static final ResourceLocation NAME = new ResourceLocation("packagedauto:processing");
    public static final IntSet SLOTS;
    public static final Vec3i COLOR;
    public static final Vec3i COLOR_HIGHLIGHT;

    protected ProcessingPackageRecipeType() {
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)"recipe.packagedauto.processing");
    }

    @Override
    public MutableComponent getShortDisplayName() {
        return Component.m_237115_((String)"recipe.packagedauto.processing.short");
    }

    @Override
    public IPackageRecipeInfo getNewRecipeInfo() {
        return new ProcessingPackageRecipeInfo();
    }

    @Override
    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    @Override
    public boolean canSetOutput() {
        return true;
    }

    @Override
    public boolean hasMachine() {
        return false;
    }

    @Override
    public boolean hasCraftingRemainingItem() {
        return false;
    }

    @Override
    public List<ResourceLocation> getJEICategories() {
        return (List)MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("jei"), () -> PackagedAutoJEIPlugin::getAllRecipeCategories, () -> ArrayList::new).get();
    }

    @Override
    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeSlotsViewWrapper recipeLayoutWrapper) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        List<IRecipeSlotViewWrapper> slotViews = recipeLayoutWrapper.getRecipeSlotViews();
        int inputIndex = 0;
        int outputIndex = 81;
        for (IRecipeSlotViewWrapper slotView : slotViews) {
            if (slotView.isInput()) {
                if (inputIndex >= 81) continue;
                displayed = slotView.getDisplayedIngredient().orElse(null);
                if (displayed instanceof ItemStack && !(stack = (ItemStack)displayed).m_41619_()) {
                    map.put(inputIndex, (Object)stack);
                    ++inputIndex;
                } else if (displayed != null && !(stack = VolumePackageItem.tryMakeVolumePackage(displayed)).m_41619_()) {
                    map.put(inputIndex, (Object)stack);
                    ++inputIndex;
                }
            } else if (slotView.isOutput()) {
                if (outputIndex >= 90) continue;
                displayed = slotView.getDisplayedIngredient().orElse(null);
                if (displayed instanceof ItemStack && !(stack = (ItemStack)displayed).m_41619_()) {
                    map.put(outputIndex, (Object)stack);
                    ++outputIndex;
                } else {
                    stack = VolumePackageItem.tryMakeVolumePackage(displayed);
                    if (!stack.m_41619_()) {
                        map.put(outputIndex, (Object)stack);
                        ++outputIndex;
                    }
                }
            }
            if (inputIndex < 81 || outputIndex < 90) continue;
            break;
        }
        return map;
    }

    @Override
    public Object getRepresentation() {
        return new ItemStack((ItemLike)Blocks.f_50094_);
    }

    @Override
    public Vec3i getSlotColor(int slot) {
        return slot == 81 ? COLOR_HIGHLIGHT : COLOR;
    }

    static {
        COLOR = new Vec3i(139, 139, 139);
        COLOR_HIGHLIGHT = new Vec3i(139, 139, 179);
        SLOTS = new IntRBTreeSet();
        IntStream.range(0, 90).forEachOrdered(arg_0 -> ((IntSet)SLOTS).add(arg_0));
    }
}

