/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.volume;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedauto.capability.StackFluidHandlerItem;
import thelm.packagedauto.client.FluidRenderer;
import thelm.packagedauto.volume.FluidStackWrapper;

public class FluidVolumeType
implements IVolumeType {
    public static final FluidVolumeType INSTANCE = new FluidVolumeType();
    public static final ResourceLocation NAME = new ResourceLocation("minecraft:fluid");

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public Class<?> getTypeClass() {
        return FluidStack.class;
    }

    @Override
    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)"volume.packagedauto.minecraft.fluid");
    }

    @Override
    public boolean supportsAE() {
        return true;
    }

    @Override
    public IVolumeStackWrapper getEmptyStackInstance() {
        return FluidStackWrapper.EMPTY;
    }

    @Override
    public Optional<IVolumeStackWrapper> wrapStack(Object volumeStack) {
        if (volumeStack instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)volumeStack;
            return Optional.of(new FluidStackWrapper(fluidStack));
        }
        return Optional.empty();
    }

    @Override
    public Optional<IVolumeStackWrapper> getStackContained(ItemStack container) {
        return FluidUtil.getFluidContained((ItemStack)container).map(FluidStackWrapper::new);
    }

    @Override
    public void setStack(ItemStack stack, IVolumeStackWrapper volumeStack) {
        if (volumeStack instanceof FluidStackWrapper) {
            FluidStackWrapper fluidStack = (FluidStackWrapper)volumeStack;
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(handler -> {
                if (handler instanceof StackFluidHandlerItem) {
                    StackFluidHandlerItem vHandler = (StackFluidHandlerItem)handler;
                    vHandler.setFluid(fluidStack.stack());
                }
            });
        }
    }

    @Override
    public IVolumeStackWrapper loadStack(CompoundTag tag) {
        return new FluidStackWrapper(FluidStack.loadFluidStackFromNBT((CompoundTag)tag));
    }

    public IFluidHandlerItem makeItemCapability(ItemStack volumePackage) {
        return new StackFluidHandlerItem(volumePackage);
    }

    public Capability<IFluidHandlerItem> getItemCapability() {
        return ForgeCapabilities.FLUID_HANDLER_ITEM;
    }

    @Override
    public boolean hasBlockCapability(ICapabilityProvider capProvider, Direction direction) {
        return capProvider.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).isPresent();
    }

    @Override
    public boolean isEmpty(ICapabilityProvider capProvider, Direction direction) {
        return capProvider.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).map(handler -> {
            if (handler.getTanks() == 0) {
                return false;
            }
            for (int i = 0; i < handler.getTanks(); ++i) {
                if (handler.getFluidInTank(i).isEmpty()) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    @Override
    public int fill(ICapabilityProvider capProvider, Direction direction, IVolumeStackWrapper resource, boolean simulate) {
        if (resource instanceof FluidStackWrapper) {
            FluidStackWrapper fluidStack = (FluidStackWrapper)resource;
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            return capProvider.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).map(handler -> handler.fill(fluidStack.stack(), action)).orElse(0);
        }
        return 0;
    }

    @Override
    public IVolumeStackWrapper drain(ICapabilityProvider capProvider, Direction direction, IVolumeStackWrapper resource, boolean simulate) {
        if (resource instanceof FluidStackWrapper) {
            FluidStackWrapper fluidStack = (FluidStackWrapper)resource;
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            return capProvider.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).map(handler -> handler.drain(fluidStack.stack(), action)).map(FluidStackWrapper::new).orElse(FluidStackWrapper.EMPTY);
        }
        return FluidStackWrapper.EMPTY;
    }

    @Override
    public void render(PoseStack poseStack, int i, int j, IVolumeStackWrapper stack) {
        if (stack instanceof FluidStackWrapper) {
            FluidStackWrapper fluidStack = (FluidStackWrapper)stack;
            FluidRenderer.INSTANCE.render(poseStack, i, j, fluidStack.stack());
        }
    }
}

