/*
 * Decompiled with CFR 0.152.
 */
package fuzs.portablehole.world.level.block.entity;

import fuzs.portablehole.PortableHole;
import fuzs.portablehole.config.ServerConfig;
import fuzs.portablehole.init.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TemporaryHoleBlockEntity
extends BlockEntity {
    private static final String TAG_BLOCK_STATE_SOURCE = "SourceState";
    private static final String TAG_BLOCK_ENTITY_SOURCE_TAG = "SourceEntityTag";
    private static final String TAG_LIFETIME_TICKS = "LifetimeTicks";
    private static final String TAG_GROWTH_DIRECTION = "GrowthDirection";
    private static final String TAG_GROWTH_DISTANCE = "GrowthDistance";
    private BlockState sourceState;
    @Nullable
    private CompoundTag blockEntityTag;
    private int lifetimeTicks;
    private Direction growthDirection;
    private int growthDistance;

    public TemporaryHoleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.TEMPORARY_HOLE_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.sourceState != null) {
            tag.m_128365_(TAG_BLOCK_STATE_SOURCE, (Tag)NbtUtils.m_129202_((BlockState)this.sourceState));
        }
        if (this.blockEntityTag != null) {
            tag.m_128365_(TAG_BLOCK_ENTITY_SOURCE_TAG, (Tag)this.blockEntityTag);
        }
        tag.m_128405_(TAG_LIFETIME_TICKS, this.lifetimeTicks);
        if (this.growthDirection != null) {
            tag.m_128344_(TAG_GROWTH_DIRECTION, (byte)this.growthDirection.ordinal());
        }
        if (this.growthDistance > 0) {
            tag.m_128405_(TAG_GROWTH_DISTANCE, this.growthDistance);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_(TAG_BLOCK_STATE_SOURCE, 10)) {
            this.sourceState = NbtUtils.m_129241_((CompoundTag)tag.m_128469_(TAG_BLOCK_STATE_SOURCE));
            if (this.sourceState.m_60795_()) {
                this.sourceState = null;
            }
        }
        if (tag.m_128425_(TAG_BLOCK_ENTITY_SOURCE_TAG, 10)) {
            this.blockEntityTag = tag.m_128469_(TAG_BLOCK_ENTITY_SOURCE_TAG);
        }
        this.lifetimeTicks = tag.m_128451_(TAG_LIFETIME_TICKS);
        if (tag.m_128425_(TAG_GROWTH_DIRECTION, 1)) {
            this.growthDirection = Direction.values()[tag.m_128445_(TAG_GROWTH_DIRECTION)];
        }
        this.growthDistance = tag.m_128451_(TAG_GROWTH_DISTANCE);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (this.sourceState != null) {
            tag.m_128365_(TAG_BLOCK_STATE_SOURCE, (Tag)NbtUtils.m_129202_((BlockState)this.sourceState));
        }
        return tag;
    }

    public BlockState getSourceBlockState() {
        return this.sourceState;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TemporaryHoleBlockEntity blockEntity) {
        if (blockEntity.sourceState == null) {
            level.m_7471_(pos, false);
        } else if (blockEntity.lifetimeTicks <= 0) {
            level.m_7731_(pos, blockEntity.sourceState, 3);
            if (blockEntity.blockEntityTag != null && level.m_7702_(pos) != null) {
                level.m_7702_(pos).m_142466_(blockEntity.blockEntityTag);
            }
            if (((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).particlesForReappearingBlocks) {
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)blockEntity.sourceState));
            }
        } else {
            --blockEntity.lifetimeTicks;
            TemporaryHoleBlockEntity.tryGrowInDirection(level, pos, blockEntity);
        }
    }

    private static void tryGrowInDirection(Level level, BlockPos pos, TemporaryHoleBlockEntity blockEntity) {
        if (blockEntity.growthDistance > 0 && blockEntity.growthDirection != null) {
            TemporaryHoleBlockEntity.setTemporaryHoleBlock(level, pos.m_121945_(blockEntity.growthDirection), blockEntity.growthDirection, blockEntity.growthDistance - 1);
            blockEntity.growthDistance = 0;
            blockEntity.growthDirection = null;
        }
    }

    public static boolean setTemporaryHoleBlock(Level level, BlockPos pos, Direction growthDirection, int growthDistance) {
        if (TemporaryHoleBlockEntity.isValidHolePosition(level, pos)) {
            BlockEntity blockEntity;
            boolean replaceBlock;
            BlockEntity blockentity;
            BlockState state = level.m_8055_(pos);
            CompoundTag blockEntityTag = null;
            if (((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).replaceBlockEntities && (blockentity = level.m_7702_(pos)) != null) {
                blockEntityTag = blockentity.m_187482_();
                Clearable.m_18908_((Object)blockentity);
            }
            boolean bl = replaceBlock = !state.m_60713_((Block)ModRegistry.TEMPORARY_HOLE_BLOCK.get());
            if (replaceBlock) {
                level.m_7731_(pos, ((Block)ModRegistry.TEMPORARY_HOLE_BLOCK.get()).m_49966_(), 3);
            }
            if ((blockEntity = level.m_7702_(pos)) instanceof TemporaryHoleBlockEntity) {
                TemporaryHoleBlockEntity blockEntity2 = (TemporaryHoleBlockEntity)blockEntity;
                if (replaceBlock) {
                    blockEntity2.sourceState = state;
                    blockEntity2.blockEntityTag = blockEntityTag;
                }
                blockEntity2.growthDirection = growthDirection;
                blockEntity2.growthDistance = growthDistance;
                blockEntity2.lifetimeTicks = ((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).temporaryHoleDuration;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidHolePosition(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (level.m_46805_(pos) && level.m_46739_(pos)) {
            if (state.m_60713_((Block)ModRegistry.TEMPORARY_HOLE_BLOCK.get())) {
                return true;
            }
            if (!(state.m_60795_() || state.m_155947_() && !((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).replaceBlockEntities || state.m_204336_(ModRegistry.PORTABLE_HOLE_IMMUNE_TAG))) {
                Block block = state.m_60734_();
                if (block instanceof DoublePlantBlock || block instanceof DoorBlock || block instanceof BedBlock) {
                    return false;
                }
                float destroySpeed = state.m_60800_((BlockGetter)level, pos);
                return destroySpeed != -1.0f && (double)destroySpeed <= ((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).maxBlockHardness;
            }
        }
        return false;
    }
}

