/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import owmii.powah.Powah;
import owmii.powah.lib.logistics.inventory.RecipeWrapper;
import owmii.powah.recipe.Recipes;

public class EnergizingRecipe
implements Recipe<RecipeWrapper> {
    public static final ResourceLocation ID = new ResourceLocation("powah", "energizing");
    protected final ResourceLocation id;
    private final ItemStack output;
    private final long energy;
    private final NonNullList<Ingredient> ingredients;

    public EnergizingRecipe(ResourceLocation id, ItemStack output, long energy, Ingredient ... ingredients) {
        this(id, output, energy, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients));
    }

    public EnergizingRecipe(ResourceLocation id, ItemStack output, long energy, NonNullList<Ingredient> ingredients) {
        this.id = id;
        this.output = output;
        this.energy = energy;
        this.ingredients = ingredients;
    }

    public boolean matches(RecipeWrapper inv, Level world) {
        ArrayList<Ingredient> stacks = new ArrayList<Ingredient>((Collection<Ingredient>)this.m_7527_());
        for (int i = 1; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            boolean flag = false;
            Iterator itr = stacks.iterator();
            while (itr.hasNext()) {
                Ingredient ingredient = (Ingredient)itr.next();
                if (!ingredient.test(stack)) continue;
                flag = true;
                itr.remove();
                break;
            }
            if (flag) continue;
            return false;
        }
        return stacks.isEmpty();
    }

    public ItemStack assemble(RecipeWrapper inv) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Recipes.ENERGIZING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Recipes.ENERGIZING.get();
    }

    public long getEnergy() {
        return this.energy;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public static class Serializer
    implements RecipeSerializer<EnergizingRecipe> {
        public EnergizingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList<Ingredient> list = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            long energy = Long.parseLong(GsonHelper.m_13851_((JsonObject)json, (String)"energy", (String)"0"));
            energy = Math.max(1L, (long)((double)energy * Powah.config().general.energizing_energy_ratio));
            if (list.isEmpty()) {
                throw new JsonParseException("No ingredients for energizing recipe");
            }
            if (list.size() > 6) {
                throw new JsonParseException("Too many ingredients for energizing recipe the max is 6");
            }
            if (energy <= 0L) {
                throw new JsonParseException("Energizing recipe require energy to work!!");
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new EnergizingRecipe(recipeId, result, energy, list);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray elements) {
            NonNullList list = NonNullList.m_122779_();
            IntStream.range(0, elements.size()).mapToObj(i -> Ingredient.m_43917_((JsonElement)elements.get(i))).filter(ingredient -> !ingredient.m_43947_()).forEach(arg_0 -> list.add(arg_0));
            return list;
        }

        @Nullable
        public EnergizingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            NonNullList list = NonNullList.m_122780_((int)buffer.readInt(), (Object)Ingredient.f_43901_);
            IntStream.range(0, list.size()).forEach(i -> list.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer)));
            return new EnergizingRecipe(recipeId, buffer.m_130267_(), buffer.readLong(), (NonNullList<Ingredient>)list);
        }

        public void toNetwork(FriendlyByteBuf buffer, EnergizingRecipe recipe) {
            buffer.writeInt(recipe.ingredients.size());
            recipe.ingredients.forEach(ingredient -> ingredient.m_43923_(buffer));
            buffer.m_130055_(recipe.output);
            buffer.writeLong(recipe.energy);
        }
    }
}

