/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config.value;

import java.util.function.Supplier;
import moze_intel.projecte.config.IPEConfig;
import moze_intel.projecte.config.value.CachedValue;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedResolvableConfigValue<TYPE, REAL>
extends CachedValue<REAL>
implements Supplier<TYPE> {
    @Nullable
    private TYPE cachedValue;

    protected CachedResolvableConfigValue(IPEConfig config, ForgeConfigSpec.ConfigValue<REAL> internal) {
        super(config, internal);
    }

    protected abstract TYPE resolve(REAL var1);

    protected abstract REAL encode(TYPE var1);

    @NotNull
    public TYPE getOrDefault() {
        if (this.cachedValue != null || this.isLoaded()) {
            return this.get();
        }
        return this.resolve(this.internal.getDefault());
    }

    @Override
    @NotNull
    public TYPE get() {
        if (this.cachedValue == null) {
            this.cachedValue = this.resolve(this.internal.get());
        }
        return this.cachedValue;
    }

    public void set(TYPE value) {
        this.internal.set(this.encode(value));
        this.cachedValue = value;
    }

    @Override
    protected boolean clearCachedValue(boolean checkChanged) {
        if (this.cachedValue == null) {
            return false;
        }
        TYPE oldCachedValue = this.cachedValue;
        this.cachedValue = null;
        return checkChanged && !oldCachedValue.equals(this.get());
    }
}

