/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl;

import com.google.common.base.Preconditions;
import java.util.UUID;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.proxy.ITransmutationProxy;
import moze_intel.projecte.impl.TransmutationOffline;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class TransmutationProxyImpl
implements ITransmutationProxy {
    public static final TransmutationProxyImpl instance = new TransmutationProxyImpl();

    private TransmutationProxyImpl() {
    }

    @Override
    @NotNull
    public IKnowledgeProvider getKnowledgeProviderFor(@NotNull UUID playerUUID) {
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER) {
            return (IKnowledgeProvider)DistExecutor.unsafeRunForDist(() -> () -> {
                Preconditions.checkState((Minecraft.m_91087_().f_91074_ != null ? 1 : 0) != 0, (Object)"Client player doesn't exist!");
                return (IKnowledgeProvider)Minecraft.m_91087_().f_91074_.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).orElseThrow(NullPointerException::new);
            }, () -> () -> {
                throw new RuntimeException("unreachable");
            });
        }
        Preconditions.checkNotNull((Object)playerUUID);
        Preconditions.checkNotNull((Object)ServerLifecycleHooks.getCurrentServer(), (Object)"Server must be running to query knowledge!");
        Player player = this.findOnlinePlayer(playerUUID);
        if (player != null) {
            return (IKnowledgeProvider)player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).orElseThrow(NullPointerException::new);
        }
        return TransmutationOffline.forPlayer(playerUUID);
    }

    private Player findOnlinePlayer(UUID playerUUID) {
        for (Player player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            if (!player.m_20148_().equals(playerUUID)) continue;
            return player;
        }
        return null;
    }
}

