/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.collectors;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.integration.jei.collectors.FuelUpgradeRecipe;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CollectorRecipeCategory
implements IRecipeCategory<FuelUpgradeRecipe> {
    public static final RecipeType<FuelUpgradeRecipe> RECIPE_TYPE = new RecipeType(PECore.rl("collector"), FuelUpgradeRecipe.class);
    private final IDrawable background;
    private final IDrawable arrow;
    private final IDrawable icon;

    public CollectorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(135, 48);
        this.arrow = guiHelper.drawableBuilder(PECore.rl("textures/gui/arrow.png"), 0, 0, 22, 15).setTextureSize(32, 32).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(PEBlocks.COLLECTOR));
    }

    @NotNull
    public RecipeType<FuelUpgradeRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return PELang.JEI_COLLECTOR.translate(new Object[0]);
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull FuelUpgradeRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 16).addItemStack(recipe.input());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 104, 16).addItemStack(recipe.output());
    }

    public void draw(FuelUpgradeRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull PoseStack matrix, double mouseX, double mouseY) {
        MutableComponent emc = PELang.EMC.translate(recipe.upgradeEMC());
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int stringWidth = fontRenderer.m_92852_((FormattedText)emc);
        fontRenderer.m_92889_(matrix, (Component)emc, (float)(this.getBackground().getWidth() - stringWidth) / 2.0f, 5.0f, 0x808080);
        this.arrow.draw(matrix, 55, 18);
    }
}

