/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.world_transmute;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Optional;
import moze_intel.projecte.api.imc.WorldTransmutationEntry;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import org.jetbrains.annotations.Nullable;

public class WorldTransmuteEntry {
    private static final StateInfo EMPTY = new StateInfo(ItemStack.f_41583_, FluidStack.EMPTY);
    private final StateInfo input;
    private final StateInfo leftOutput;
    private final StateInfo rightOutput;

    public WorldTransmuteEntry(WorldTransmutationEntry transmutationEntry) {
        BlockState leftOutputState = transmutationEntry.result();
        BlockState rightOutputState = transmutationEntry.altResult();
        if (leftOutputState == rightOutputState) {
            rightOutputState = null;
        }
        this.input = this.createInfo(transmutationEntry.origin());
        this.leftOutput = this.createInfo(leftOutputState);
        this.rightOutput = this.createInfo(rightOutputState);
    }

    private StateInfo createInfo(@Nullable BlockState output) {
        if (output == null) {
            return EMPTY;
        }
        FluidStack outputFluid = this.fluidFromBlock(output.m_60734_());
        if (outputFluid.isEmpty()) {
            return new StateInfo(this.itemFromBlock(output.m_60734_(), output), outputFluid);
        }
        return new StateInfo(ItemStack.f_41583_, outputFluid);
    }

    private FluidStack fluidFromBlock(Block block) {
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            return new FluidStack((Fluid)liquidBlock.getFluid(), 1000);
        }
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            return new FluidStack(fluidBlock.getFluid(), 1000);
        }
        return FluidStack.EMPTY;
    }

    private ItemStack itemFromBlock(Block block, BlockState state) {
        try {
            return block.getCloneItemStack(state, null, null, null, null);
        }
        catch (Exception e) {
            return new ItemStack((ItemLike)block);
        }
    }

    public boolean isRenderable() {
        return !this.input.isEmpty() && (!this.leftOutput.isEmpty() || !this.rightOutput.isEmpty());
    }

    public Optional<Either<ItemStack, FluidStack>> getInput() {
        if (this.input.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.input.toEither());
    }

    public Iterable<Either<ItemStack, FluidStack>> getOutput() {
        ArrayList<Either<ItemStack, FluidStack>> outputs = new ArrayList<Either<ItemStack, FluidStack>>();
        if (!this.leftOutput.isEmpty()) {
            outputs.add(this.leftOutput.toEither());
        }
        if (!this.rightOutput.isEmpty()) {
            outputs.add(this.rightOutput.toEither());
        }
        return outputs;
    }

    public ItemStack getInputItem() {
        return this.input.item();
    }

    public FluidStack getInputFluid() {
        return this.input.fluid();
    }

    private record StateInfo(ItemStack item, FluidStack fluid) {
        public boolean isEmpty() {
            return this.item.m_41619_() && this.fluid.isEmpty();
        }

        public Either<ItemStack, FluidStack> toEither() {
            if (this.fluid.isEmpty()) {
                return Either.left((Object)this.item);
            }
            return Either.right((Object)this.fluid);
        }
    }
}

