/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.world_transmute;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.imc.WorldTransmutationEntry;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.integration.jei.world_transmute.WorldTransmuteEntry;
import moze_intel.projecte.utils.WorldTransmutations;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class WorldTransmuteRecipeCategory
implements IRecipeCategory<WorldTransmuteEntry> {
    public static final RecipeType<WorldTransmuteEntry> RECIPE_TYPE = new RecipeType(PECore.rl("world_transmutation"), WorldTransmuteEntry.class);
    private final IDrawable background;
    private final IDrawable arrow;
    private final IDrawable icon;

    public WorldTransmuteRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(135, 48);
        this.arrow = guiHelper.drawableBuilder(PECore.rl("textures/gui/arrow.png"), 0, 0, 22, 15).setTextureSize(32, 32).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(PEItems.PHILOSOPHERS_STONE));
    }

    @NotNull
    public RecipeType<WorldTransmuteEntry> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return PELang.WORLD_TRANSMUTE.translate(new Object[0]);
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@NotNull WorldTransmuteEntry recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull PoseStack matrix, double mouseX, double mouseY) {
        this.arrow.draw(matrix, 55, 18);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull WorldTransmuteEntry recipe, @NotNull IFocusGroup focuses) {
        recipe.getInput().ifPresent(recipeInput -> recipeInput.ifLeft(input -> builder.addSlot(RecipeIngredientRole.INPUT, 16, 16).addItemStack(input)).ifRight(input -> ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 16, 16).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, input)).setFluidRenderer(1000L, false, 16, 16)));
        int xPos = 96;
        for (Either<ItemStack, FluidStack> output : recipe.getOutput()) {
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.OUTPUT, xPos, 16);
            output.ifLeft(arg_0 -> ((IRecipeSlotBuilder)slot).addItemStack(arg_0)).ifRight(input -> ((IRecipeSlotBuilder)slot.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, input)).setFluidRenderer(1000L, false, 16, 16));
            xPos += 16;
        }
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull WorldTransmuteEntry recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 67.0 && mouseX < 107.0 && mouseY > 18.0 && mouseY < 38.0) {
            return Collections.singletonList(PELang.WORLD_TRANSMUTE_DESCRIPTION.translate(new Object[0]));
        }
        return Collections.emptyList();
    }

    public static List<WorldTransmuteEntry> getAllTransmutations() {
        List<WorldTransmutationEntry> allWorldTransmutations = WorldTransmutations.getWorldTransmutations();
        ArrayList<WorldTransmuteEntry> visible = new ArrayList<WorldTransmuteEntry>();
        allWorldTransmutations.forEach(entry -> {
            WorldTransmuteEntry e = new WorldTransmuteEntry((WorldTransmutationEntry)entry);
            if (e.isRenderable()) {
                boolean alreadyHas;
                FluidStack inputFluid = e.getInputFluid();
                if (inputFluid.isEmpty()) {
                    ItemStack inputItem = e.getInputItem();
                    alreadyHas = visible.stream().map(WorldTransmuteEntry::getInputItem).anyMatch(otherInputItem -> !otherInputItem.m_41619_() && inputItem.m_41656_(otherInputItem));
                } else {
                    alreadyHas = visible.stream().map(WorldTransmuteEntry::getInputFluid).anyMatch(otherInputFluid -> !otherInputFluid.isEmpty() && inputFluid.isFluidEqual(otherInputFluid));
                }
                if (!alreadyHas) {
                    visible.add(e);
                }
            }
        });
        return visible;
    }
}

