/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import java.util.function.Predicate;
import moze_intel.projecte.PEPermissions;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeClearPKT;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class KnowledgeCMD {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext context) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"knowledge").requires((Predicate)PEPermissions.COMMAND_KNOWLEDGE)).then(KnowledgeCMD.subCommandClear())).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"learn").requires((Predicate)PEPermissions.COMMAND_KNOWLEDGE_LEARN)).then(KnowledgeCMD.executeWithParameters(ActionType.LEARN, context)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unlearn").requires((Predicate)PEPermissions.COMMAND_KNOWLEDGE_UNLEARN)).then(KnowledgeCMD.executeWithParameters(ActionType.UNLEARN, context)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"test").requires((Predicate)PEPermissions.COMMAND_KNOWLEDGE_TEST)).then(KnowledgeCMD.executeWithParameters(ActionType.TEST, context)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> executeWithParameters(ActionType actionType, CommandBuildContext context) {
        return Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)context)).executes(ctx -> KnowledgeCMD.handle((CommandContext<CommandSourceStack>)ctx, actionType)));
    }

    @Nullable
    private static IKnowledgeProvider getProvider(ServerPlayer player) {
        Optional cap = player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).resolve();
        return cap.orElse(null);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> subCommandClear() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires((Predicate)PEPermissions.COMMAND_KNOWLEDGE_CLEAR)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            int successCount = 0;
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)ctx, (String)"targets")) {
                IKnowledgeProvider provider = KnowledgeCMD.getProvider(player);
                if (provider == null) {
                    source.m_81352_((Component)PELang.COMMAND_PROVIDER_FAIL.translate(player.m_5446_()));
                    continue;
                }
                if (provider.getKnowledge().isEmpty()) {
                    source.m_81352_((Component)PELang.COMMAND_KNOWLEDGE_CLEAR_FAIL.translate(player.m_5446_()));
                    continue;
                }
                provider.clearKnowledge();
                PacketHandler.sendTo(new KnowledgeClearPKT(), player);
                source.m_81354_((Component)PELang.COMMAND_KNOWLEDGE_CLEAR_SUCCESS.translateColored(ChatFormatting.GREEN, player.m_5446_()), true);
                ++successCount;
            }
            return successCount;
        }));
    }

    private static int handle(CommandContext<CommandSourceStack> ctx, ActionType action) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        IKnowledgeProvider provider = KnowledgeCMD.getProvider(player);
        if (provider == null) {
            source.m_81352_((Component)PELang.COMMAND_PROVIDER_FAIL.translate(player.m_5446_()));
            return 0;
        }
        ItemStack item = new ItemStack((ItemLike)ItemArgument.m_120963_(ctx, (String)"item").m_120979_());
        if (!EMCHelper.doesItemHaveEmc(item)) {
            source.m_81352_((Component)PELang.COMMAND_KNOWLEDGE_INVALID.translate(item.m_41611_()));
            return 0;
        }
        switch (action) {
            case LEARN: {
                if (provider.hasKnowledge(item)) {
                    return KnowledgeCMD.failure(source, PELang.COMMAND_KNOWLEDGE_LEARN_FAIL, (Player)player, item);
                }
                provider.addKnowledge(item);
                source.m_81354_((Component)PELang.COMMAND_KNOWLEDGE_LEARN_SUCCESS.translateColored(ChatFormatting.GREEN, player.m_5446_(), item.m_41611_()), true);
                break;
            }
            case UNLEARN: {
                if (!provider.hasKnowledge(item)) {
                    return KnowledgeCMD.failure(source, PELang.COMMAND_KNOWLEDGE_UNLEARN_FAIL, (Player)player, item);
                }
                provider.removeKnowledge(item);
                source.m_81354_((Component)PELang.COMMAND_KNOWLEDGE_UNLEARN_SUCCESS.translateColored(ChatFormatting.GREEN, player.m_5446_(), item.m_41611_()), true);
                break;
            }
            case TEST: {
                if (provider.hasKnowledge(item)) {
                    source.m_81354_((Component)PELang.COMMAND_KNOWLEDGE_TEST_SUCCESS.translateColored(ChatFormatting.GREEN, player.m_5446_(), item.m_41611_()), true);
                    return 1;
                }
                return KnowledgeCMD.failure(source, PELang.COMMAND_KNOWLEDGE_TEST_FAIL, (Player)player, item);
            }
        }
        provider.syncKnowledgeChange(player, NBTManager.getPersistentInfo(ItemInfo.fromStack(item)), action == ActionType.LEARN);
        return 1;
    }

    private static int failure(CommandSourceStack source, ILangEntry failureMessage, Player player, ItemStack item) {
        source.m_81352_((Component)failureMessage.translate(player.m_5446_(), item.m_41611_()));
        return 0;
    }

    private static enum ActionType {
        LEARN,
        UNLEARN,
        TEST;

    }
}

