/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.rainshield.block;

import com.mrbysco.rainshield.util.RainShieldData;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class RainShieldBlock
extends RodBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public RainShieldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if (level.m_46471_() && !((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            for (double mod = 0.0; mod < 1.0; mod += 0.25) {
                for (double a = 0.0; a <= Math.PI * 2; a += 0.3141592653589793) {
                    double x = (double)pos.m_123341_() + 0.5 + (1.0 - mod) * Math.cos(a);
                    double z = (double)pos.m_123343_() + 0.5 + (1.0 - mod) * Math.sin(a);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x, (double)((float)pos.m_123342_() + 1.7f) + mod, z, 0.0, 0.02, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, (double)((float)pos.m_123342_() + 1.6f) + mod, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        RainShieldData.addRainShieldPos(pos, level);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean p_51542_) {
        if (!state.m_60713_(newState.m_60734_())) {
            RainShieldData.removeRainShieldPos(pos, level);
            super.m_6810_(state, level, pos, newState, p_51542_);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos p_55670_, boolean p_55671_) {
        boolean flag;
        if (!level.f_46443_ && (flag = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) != level.m_46753_(pos)) {
            if (flag) {
                level.m_186460_(pos, (Block)this, 4);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
            }
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && !level.m_46753_(pos)) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        FluidState fluidstate = placeContext.m_43725_().m_6425_(placeContext.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)placeContext.m_43719_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState p_153741_, LevelAccessor levelAccessor, BlockPos pos, BlockPos p_153744_) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(state, direction, p_153741_, levelAccessor, pos, p_153744_);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{f_52588_, POWERED, WATERLOGGED});
    }
}

