/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.rainshield.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mrbysco.rainshield.registry.RainShieldRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RainShieldDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_236039_(event.includeServer(), (DataProvider)new Loots(generator));
            generator.m_236039_(event.includeServer(), (DataProvider)new Recipes(generator));
        }
        if (event.includeClient()) {
            generator.m_236039_(event.includeClient(), (DataProvider)new Language(generator));
            generator.m_236039_(event.includeClient(), (DataProvider)new BlockModels(generator, helper));
            generator.m_236039_(event.includeClient(), (DataProvider)new ItemModels(generator, helper));
            generator.m_236039_(event.includeClient(), (DataProvider)new BlockStates(generator, helper));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(GeOreBlockTables::new, (Object)LootContextParamSets.f_81421_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)name, (LootTable)table));
        }

        public static class GeOreBlockTables
        extends BlockLoot {
            protected void addTables() {
                this.m_124288_((Block)RainShieldRegistry.RAIN_SHIELD.get());
            }

            protected Iterable<Block> getKnownBlocks() {
                return RainShieldRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    public static class Recipes
    extends RecipeProvider {
        public Recipes(DataGenerator generator) {
            super(generator);
        }

        protected void m_176531_(Consumer<FinishedRecipe> recipeConsumer) {
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)RainShieldRegistry.RAIN_SHIELD.get())).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42484_).m_206416_(Character.valueOf('B'), Tags.Items.RODS_BLAZE).m_206416_(Character.valueOf('N'), Tags.Items.NETHERRACK).m_126130_(" F ").m_126130_(" B ").m_126130_("NNN").m_126132_("has_blaze_rod", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.RODS_BLAZE)).m_176498_(recipeConsumer);
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(DataGenerator gen) {
            super(gen, "rainshield", "en_us");
        }

        protected void addTranslations() {
            this.addBlock((Supplier)RainShieldRegistry.RAIN_SHIELD, "Rain Shield");
        }
    }

    private static class BlockModels
    extends BlockModelProvider {
        public BlockModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "rainshield", helper);
        }

        protected void registerModels() {
            this.makeRod((Block)RainShieldRegistry.RAIN_SHIELD.get());
        }

        private void makeRod(Block block) {
            ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)block);
            ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(location.m_135815_(), this.modLoc("block/rod"))).texture("particle", "block/" + location.m_135815_())).texture("rod", "block/" + location.m_135815_());
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "rainshield", helper);
        }

        protected void registerModels() {
            ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)((Item)RainShieldRegistry.RAIN_SHIELD_ITEM.get()));
            this.withExistingParent(location.m_135815_(), this.modLoc("block/" + location.m_135815_()));
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "rainshield", helper);
        }

        protected void registerStatesAndModels() {
            this.makeRod((Block)RainShieldRegistry.RAIN_SHIELD.get());
        }

        private void makeRod(Block block) {
            ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_()));
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)model).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(270).addModel();
        }
    }
}

