/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.sandbox.datagen.registry;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import io.github.noeppi_noeppi.mods.sandbox.datagen.registry.RegistryExtension;
import io.github.noeppi_noeppi.mods.sandbox.impl.WorldGenRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class WorldGenRegistries {
    private final Map<ResourceKey<? extends Registry<?>>, WritableRegistry<?>> registries = new HashMap();
    private final Set<ResourceKey<? extends Registry<?>>> frozenRegistries = new HashSet();
    private final Map<ResourceKey<? extends Registry<?>>, Set<Holder.Reference<?>>> intrusiveHolders = new HashMap();
    private final Map<ResourceKey<? extends Registry<?>>, RegistryExtension<?, ?>> extensions = new HashMap();
    private final RegistryAccess registryAccess = new WorldGenRegistryAccess();
    private boolean frozen = false;

    private static boolean isDatapackRegistry(ResourceKey<? extends Registry<?>> key) {
        return !Registry.f_122897_.m_142003_(key);
    }

    private <T> WritableRegistry<T> writableRegistry(ResourceKey<? extends Registry<T>> key) {
        if (!WorldGenRegistries.isDatapackRegistry(key)) {
            throw new IllegalArgumentException("Can't write to non-datapack registry: " + key);
        }
        WritableRegistry registry = this.registries.computeIfAbsent(key, k -> {
            WorldGenRegistry newReg = new WorldGenRegistry(key, Lifecycle.stable(), null);
            ((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_6632_(key).ifPresent(builtin -> builtin.m_203611_().forEach(builtinValue -> {
                if (builtinValue.m_203633_()) {
                    newReg.m_203505_(builtinValue.m_205785_(), builtinValue.m_203334_(), Lifecycle.stable());
                }
            }));
            return newReg;
        });
        if (this.frozen && !this.frozenRegistries.contains(key)) {
            this.freeze(key, registry);
        }
        return registry;
    }

    private <T, E> RegistryExtension<T, E> extension(ResourceKey<? extends Registry<T>> registry, ResourceKey<? extends Registry<E>> extendedRegistry) {
        if (!this.extensions.containsKey(registry)) {
            RegistryExtension ext = new RegistryExtension(registry, extendedRegistry);
            this.extensions.put(registry, ext);
            return ext;
        }
        RegistryExtension<?, ?> ext = this.extensions.get(registry);
        if (!Objects.equals(ext.extendedRegistry, extendedRegistry)) {
            throw new IllegalArgumentException("Can't initialise registry extension on " + registry + " with " + extendedRegistry + ", already extends " + ext.extendedRegistry);
        }
        return ext;
    }

    public <T> Registry<T> registry(ResourceKey<? extends Registry<T>> key) {
        if (WorldGenRegistries.isDatapackRegistry(key)) {
            return this.writableRegistry(key);
        }
        return (Registry)Registry.f_122897_.m_6246_(key);
    }

    public <T> void register(ResourceKey<? extends Registry<T>> registryKey, ResourceLocation id, T value) {
        this.writableRegistry(registryKey).m_203505_(ResourceKey.m_135785_(registryKey, (ResourceLocation)id), value, Lifecycle.stable());
    }

    public <T, E> void registerExtension(ResourceKey<? extends Registry<T>> registry, ResourceKey<? extends Registry<E>> sourceRegistry, T value, Holder<E> source) {
        this.extension(registry, sourceRegistry).extendsWith(value, source);
    }

    public <T> void assignId(ResourceKey<? extends Registry<T>> registryKey, ResourceLocation id, T value) {
        RegistryExtension<?, ?> ext;
        if (this.registry(registryKey).m_7981_(value) != null) {
            return;
        }
        if (this.extensions.containsKey(registryKey) && (ext = this.extensions.get(registryKey)).hasElement(value)) {
            return;
        }
        this.register(registryKey, id, value);
    }

    public <T> void register(ResourceKey<? extends Registry<T>> registryKey, ResourceLocation id, Holder<T> value) {
        switch (value.m_203376_()) {
            case REFERENCE: {
                break;
            }
            case DIRECT: {
                this.register(registryKey, id, value.m_203334_());
            }
        }
    }

    public <T> Holder<T> holder(ResourceKey<? extends Registry<T>> registryKey, ResourceLocation id) {
        return this.registry(registryKey).m_214121_(ResourceKey.m_135785_(registryKey, (ResourceLocation)id));
    }

    public <T> HolderSet<T> tag(TagKey<T> key) {
        return this.registry(key.f_203867_()).m_203561_(key);
    }

    public <T> Holder<T> holder(ResourceKey<? extends Registry<T>> registryKey, T value) {
        if (this.frozenRegistries.contains(registryKey)) {
            throw new IllegalStateException("Registry is already frozen (trying to add value " + value + ")");
        }
        Holder.Reference holder = Holder.Reference.m_205763_(this.registry(registryKey), value);
        this.intrusiveHolders.computeIfAbsent(registryKey, k -> new HashSet()).add(holder);
        return holder;
    }

    public <T> Holder<T> holder(ResourceKey<? extends Registry<T>> registryKey, Holder<T> value) {
        return switch (value.m_203376_()) {
            default -> throw new IncompatibleClassChangeError();
            case Holder.Kind.DIRECT -> this.holder(registryKey, value.m_203334_());
            case Holder.Kind.REFERENCE -> ((Holder.Reference)value).getType() == Holder.Reference.Type.STAND_ALONE || value.m_203633_() ? this.holder(registryKey, (T)((Holder.Reference)value).m_205785_().m_135782_()) : this.holder(registryKey, value.m_203334_());
        };
    }

    public void freezeAll() {
        for (ResourceKey<? extends Registry<?>> resourceKey : this.registries.keySet()) {
            this.freeze(resourceKey);
        }
        this.frozen = true;
    }

    public <T> void freeze(ResourceKey<? extends Registry<T>> key) {
        this.freeze(key, this.writableRegistry(key));
    }

    private <T> void freeze(ResourceKey<? extends Registry<T>> key, WritableRegistry<T> registry) {
        if (!this.frozenRegistries.contains(key)) {
            if (this.extensions.containsKey(key)) {
                RegistryExtension<?, ?> ext = this.extensions.get(key);
                this.freeze(ext.extendedRegistry);
                ext.loadIds(registry, this.registry(ext.extendedRegistry));
            }
            if (this.intrusiveHolders.containsKey(key)) {
                for (Holder.Reference<?> holder : this.intrusiveHolders.get(key)) {
                    if (holder.getType() == Holder.Reference.Type.INTRUSIVE) {
                        Optional elemKey = registry.m_7854_(holder.m_203334_());
                        if (elemKey.isPresent()) {
                            holder.m_205775_((ResourceKey)elemKey.get(), holder.m_203334_());
                        } else {
                            throw new IllegalStateException("Element not added to registry: " + key + ": " + holder.m_203334_());
                        }
                    }
                    if (holder.m_203633_()) continue;
                    throw new IllegalStateException("Unbound holder: " + key + ": " + holder);
                }
            }
            this.frozenRegistries.add(key);
            try {
                registry.m_203521_();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public RegistryAccess registryAccess() {
        return this.registryAccess;
    }

    public <T> DynamicOps<T> dynamicOps(DynamicOps<T> ops) {
        return RegistryOps.m_206821_(ops, (RegistryAccess)this.registryAccess());
    }

    private class WorldGenRegistryAccess
    implements RegistryAccess {
        private WorldGenRegistryAccess() {
        }

        @Nonnull
        public <E> Optional<Registry<E>> m_142664_(@Nonnull ResourceKey<? extends Registry<? extends E>> key) {
            if (!WorldGenRegistries.isDatapackRegistry(key)) {
                return Optional.empty();
            }
            if (WorldGenRegistries.this.frozen || WorldGenRegistries.this.frozenRegistries.contains(key)) {
                return Optional.of(WorldGenRegistries.this.registry(key));
            }
            return Optional.empty();
        }

        @Nonnull
        public Stream<RegistryAccess.RegistryEntry<?>> m_203610_() {
            HashSet keys = new HashSet(WorldGenRegistries.this.frozenRegistries);
            if (WorldGenRegistries.this.frozen) {
                for (RegistryAccess.RegistryData reg : RegistryAccess.m_194613_()) {
                    keys.add(reg.f_123101_());
                }
            }
            return keys.stream().map(key -> this.entry((ResourceKey)key));
        }

        private <T> RegistryAccess.RegistryEntry<T> entry(ResourceKey<? extends Registry<T>> key) {
            return new RegistryAccess.RegistryEntry(key, WorldGenRegistries.this.registry(key));
        }
    }
}

