/*
 * Decompiled with CFR 0.152.
 */
package jackyy.simplesponge.item;

import jackyy.gunpowderlib.helper.EnergyHelper;
import jackyy.gunpowderlib.helper.NBTHelper;
import jackyy.gunpowderlib.helper.StringHelper;
import jackyy.simplesponge.SimpleSponge;
import jackyy.simplesponge.registry.ModConfigs;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemSpongeOnAStickBase
extends Item {
    public ItemSpongeOnAStickBase(Item.Properties props) {
        super(props.m_41491_(SimpleSponge.TAB));
    }

    public int getEnergy() {
        return this.getEnergy();
    }

    public int getPerRightClickUse() {
        return this.getPerRightClickUse();
    }

    public int getRange() {
        return this.getRange();
    }

    public boolean isMagmatic() {
        return this.isMagmatic();
    }

    public boolean isCreative() {
        return false;
    }

    public boolean isPowered() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advanced) {
        super.m_7373_(stack, world, tooltip, advanced);
        if (!this.isPowered()) {
            tooltip.add((Component)StringHelper.formatNumber((long)(stack.m_41776_() - stack.m_41773_())).m_130946_(" / ").m_7220_((Component)StringHelper.formatNumber((long)stack.m_41776_())).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.simplesponge.durability")));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return this.soakUp(context.m_43725_(), context.m_8083_(), context.m_43723_(), context.m_43722_()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        boolean result = this.soakUp(world, player.m_20097_(), player, player.m_21120_(hand));
        return result ? InteractionResultHolder.m_19098_((Object)player.m_21120_(hand)) : InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    private boolean soakUp(Level world, BlockPos pos, Player player, ItemStack stack) {
        boolean succ = false;
        boolean hitLava = false;
        boolean allowHotLiquid = (Boolean)ModConfigs.CONFIG.regularSpongeAbsorbHotLiquid.get();
        int dmg = stack.m_41773_();
        int maxDmg = stack.m_41776_();
        for (int x = -this.getRange(); x <= this.getRange(); ++x) {
            block1: for (int y = -this.getRange(); y <= this.getRange(); ++y) {
                for (int z = -this.getRange(); z <= this.getRange(); ++z) {
                    BlockPos targetPos = pos.m_7918_(x, y, z);
                    BlockState state = world.m_8055_(targetPos);
                    Material material = world.m_8055_(targetPos).m_60767_();
                    if (material.m_76332_()) {
                        succ = true;
                        if ((hitLava |= material == Material.f_76307_) && !this.isMagmatic() && !allowHotLiquid) continue block1;
                        world.m_7731_(targetPos, Blocks.f_50016_.m_49966_(), 3);
                        if (player.m_7500_() || this.isCreative() || (this.isPowered() || ++dmg < maxDmg) && (!this.isPowered() || EnergyHelper.getEnergyStored((ItemStack)stack) >= this.getPerRightClickUse())) continue;
                        continue block1;
                    }
                    if (state.m_61138_((Property)BlockStateProperties.f_61362_) && state.m_61147_().contains(BlockStateProperties.f_61362_)) {
                        succ = true;
                        hitLava = false;
                        world.m_7731_(targetPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
                        if (player.m_7500_() || this.isCreative() || (this.isPowered() || ++dmg < maxDmg) && (!this.isPowered() || EnergyHelper.getEnergyStored((ItemStack)stack) >= this.getPerRightClickUse())) continue;
                        continue block1;
                    }
                    if (material != Material.f_76301_ && material != Material.f_76304_) continue;
                    succ = true;
                    hitLava = false;
                    BlockEntity tile = state.m_155947_() ? world.m_7702_(targetPos) : null;
                    Block.m_49892_((BlockState)state, (LevelAccessor)world, (BlockPos)targetPos, (BlockEntity)tile);
                    world.m_7731_(targetPos, Blocks.f_50016_.m_49966_(), 3);
                    if (!player.m_7500_() && !this.isCreative() && (!this.isPowered() && ++dmg >= maxDmg || this.isPowered() && EnergyHelper.getEnergyStored((ItemStack)stack) < this.getPerRightClickUse())) continue block1;
                }
            }
        }
        if (hitLava && !this.isMagmatic() && allowHotLiquid) {
            stack.m_41764_(0);
            player.m_20254_(6);
        }
        if (succ) {
            if (!player.m_7500_() && !this.isCreative()) {
                if (this.isPowered()) {
                    if (EnergyHelper.getEnergyStored((ItemStack)stack) >= this.getPerRightClickUse()) {
                        NBTHelper.setInt((ItemStack)stack, (String)"Energy", (int)(EnergyHelper.getEnergyStored((ItemStack)stack) - this.getPerRightClickUse()));
                    }
                } else {
                    if (dmg >= maxDmg) {
                        stack.m_41764_(0);
                    }
                    stack.m_41721_(dmg);
                }
            }
            return true;
        }
        return false;
    }
}

