/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travelanchors;

import de.castcrafter.travelanchors.ModBlocks;
import de.castcrafter.travelanchors.ModEnchantments;
import de.castcrafter.travelanchors.ModItems;
import de.castcrafter.travelanchors.TravelAnchorList;
import de.castcrafter.travelanchors.block.TileTravelAnchor;
import de.castcrafter.travelanchors.config.CommonConfig;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class TeleportHandler {
    public static boolean anchorTeleport(Level level, Player player, @Nullable BlockPos except, @Nullable InteractionHand hand) {
        Pair<BlockPos, String> anchor = TeleportHandler.getAnchorToTeleport(level, player, except);
        return TeleportHandler.teleportPlayer(player, anchor, hand);
    }

    public static Pair<BlockPos, String> getAnchorToTeleport(Level level, Player player, @Nullable BlockPos except) {
        if (!player.m_6144_()) {
            double maxDistance = TeleportHandler.getMaxDistance(player);
            Vec3 positionVec = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
            Optional<Pair> anchor = TravelAnchorList.get(level).getAnchorsAround(player.m_20182_(), Math.pow(maxDistance, 2.0)).filter(pair -> except == null || !except.equals(pair.getLeft())).filter(p -> Math.abs(TeleportHandler.getAngleRadians(positionVec, (BlockPos)p.getLeft(), player.m_146908_(), player.m_146909_())) <= Math.toRadians(CommonConfig.max_angle)).min((p1, p2) -> {
                double angle2;
                double angle1 = TeleportHandler.getAngleRadians(positionVec, (BlockPos)p1.getLeft(), player.m_146908_(), player.m_146909_());
                if (Math.abs(Mth.m_14175_((double)(angle1 - (angle2 = TeleportHandler.getAngleRadians(positionVec, (BlockPos)p2.getLeft(), player.m_146908_(), player.m_146909_()))))) < 0.1) {
                    double dst1sqr = positionVec.m_82531_((double)((BlockPos)p1.getLeft()).m_123341_() + 0.5, (double)(((BlockPos)p1.getLeft()).m_123342_() + 1), (double)((BlockPos)p1.getLeft()).m_123343_() + 0.5);
                    double dst2sqr = positionVec.m_82531_((double)((BlockPos)p2.getLeft()).m_123341_() + 0.5, (double)(((BlockPos)p2.getLeft()).m_123342_() + 1), (double)((BlockPos)p2.getLeft()).m_123343_() + 0.5);
                    double anchorDistSqr = ((BlockPos)p1.getLeft()).m_123331_((Vec3i)p2.getLeft());
                    if (Math.min(dst1sqr, dst2sqr) < anchorDistSqr * 4.0) {
                        return Double.compare(dst1sqr, dst2sqr);
                    }
                }
                return Double.compare(Math.abs(angle1), Math.abs(angle2));
            }).filter(p -> TeleportHandler.canTeleportTo((BlockGetter)level, (BlockPos)p.getLeft()));
            return anchor.orElse(null);
        }
        return null;
    }

    public static boolean teleportPlayer(Player player, @Nullable Pair<BlockPos, String> anchor, @Nullable InteractionHand hand) {
        if (anchor != null) {
            if (!player.m_9236_().f_46443_) {
                Vec3 teleportVec = TeleportHandler.checkTeleport(player, ((BlockPos)anchor.getLeft()).m_7494_());
                if (teleportVec == null) {
                    return false;
                }
                player.m_6021_(teleportVec.m_7096_(), teleportVec.m_7098_(), teleportVec.m_7094_());
            }
            player.f_19789_ = 0.0f;
            if (hand != null) {
                player.m_21011_(hand, true);
            }
            player.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.f_19853_.f_46443_) {
                player.m_5661_((Component)Component.m_237110_((String)"travelanchors.tp.success", (Object[])new Object[]{anchor.getRight()}), true);
            }
            return true;
        }
        if (!player.f_19853_.f_46443_) {
            player.m_5661_((Component)Component.m_237115_((String)"travelanchors.tp.fail"), true);
        }
        return false;
    }

    public static boolean shortTeleport(Level level, Player player, InteractionHand hand) {
        Vec3 targetVec = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 lookVec = player.m_20154_();
        BlockPos target = null;
        for (double i = CommonConfig.max_short_tp_distance; i >= 2.0; i -= 0.5) {
            Vec3 v3d = targetVec.m_82549_(lookVec.m_82542_(i, i, i));
            target = new BlockPos((double)Math.round(v3d.f_82479_), (double)Math.round(v3d.f_82480_), (double)Math.round(v3d.f_82481_));
            if (TeleportHandler.canTeleportTo((BlockGetter)level, target.m_7495_())) break;
            target = null;
        }
        if (target != null) {
            if (!player.m_9236_().f_46443_) {
                Vec3 teleportVec = TeleportHandler.checkTeleport(player, target);
                if (teleportVec == null) {
                    return false;
                }
                player.m_6021_(teleportVec.m_7096_(), teleportVec.m_7098_(), teleportVec.m_7094_());
            }
            player.f_19789_ = 0.0f;
            player.m_21011_(hand, true);
            player.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        if (!player.f_19853_.f_46443_) {
            player.m_5661_((Component)Component.m_237115_((String)"travelanchors.hop.fail"), true);
        }
        return false;
    }

    public static boolean canTeleportTo(BlockGetter level, BlockPos target) {
        return !level.m_8055_(target.m_7949_().m_6630_(1)).m_60815_() && !level.m_8055_(target.m_7949_().m_6630_(2)).m_60815_() && target.m_123342_() >= level.m_141937_();
    }

    public static boolean canPlayerTeleportAnyHand(Player player) {
        return TeleportHandler.canPlayerTeleport(player, InteractionHand.MAIN_HAND) || TeleportHandler.canPlayerTeleport(player, InteractionHand.OFF_HAND);
    }

    public static boolean canPlayerTeleport(Player player, InteractionHand hand) {
        return TeleportHandler.canItemTeleport(player, hand) || TeleportHandler.canBlockTeleport(player);
    }

    public static boolean canBlockTeleport(Player player) {
        return player.m_9236_().m_8055_(player.m_20183_().m_7949_().m_7495_()).m_60734_() == ModBlocks.travelAnchor && !player.m_6144_();
    }

    public static boolean canItemTeleport(Player player, InteractionHand hand) {
        return player.m_21120_(hand).m_41720_() == ModItems.travelStaff || player.m_21120_(hand).getEnchantmentLevel(ModEnchantments.teleportation) >= 1;
    }

    private static double getAngleRadians(Vec3 positionVec, BlockPos anchor, float yRot, float xRot) {
        Vec3 blockVec = new Vec3((double)anchor.m_123341_() + 0.5 - positionVec.f_82479_, (double)anchor.m_123342_() + 1.0 - positionVec.f_82480_, (double)anchor.m_123343_() + 0.5 - positionVec.f_82481_).m_82541_();
        Vec3 lookVec = Vec3.m_82498_((float)xRot, (float)yRot).m_82541_();
        return Math.acos(lookVec.m_82526_(blockVec));
    }

    public static double getMaxDistance(Player player) {
        int mainHandLevel = player.m_21120_(InteractionHand.MAIN_HAND).getEnchantmentLevel(ModEnchantments.range);
        int offHandLevel = player.m_21120_(InteractionHand.OFF_HAND).getEnchantmentLevel(ModEnchantments.range);
        int lvl = Math.max(mainHandLevel, offHandLevel);
        return CommonConfig.max_distance * (1.0 + (double)lvl / 2.0);
    }

    public static boolean canElevate(Player player) {
        return player.m_9236_().m_8055_(player.m_20183_().m_7949_().m_7495_()).m_60734_() == ModBlocks.travelAnchor;
    }

    public static boolean elevateUp(Player player) {
        BlockPos target;
        String name;
        if (!TeleportHandler.canElevate(player)) {
            return false;
        }
        Level level = player.m_9236_();
        BlockPos.MutableBlockPos searchPos = player.m_20183_().m_7949_().m_122032_();
        while (!(level.m_151570_((BlockPos)searchPos) || level.m_8055_((BlockPos)searchPos).m_60734_() == ModBlocks.travelAnchor && TeleportHandler.canTeleportTo((BlockGetter)level, (BlockPos)searchPos))) {
            searchPos.m_122173_(Direction.UP);
        }
        BlockState state = level.m_8055_((BlockPos)searchPos);
        Pair anchor = null;
        if (state.m_60734_() == ModBlocks.travelAnchor && TeleportHandler.canTeleportTo((BlockGetter)level, (BlockPos)searchPos) && !(name = ((TileTravelAnchor)ModBlocks.travelAnchor.getBlockEntity(level, target = searchPos.m_7949_())).getName()).isEmpty()) {
            anchor = Pair.of((Object)target, (Object)name);
        }
        return TeleportHandler.teleportPlayer(player, anchor, null);
    }

    public static boolean elevateDown(Player player) {
        BlockPos target;
        String name;
        if (!TeleportHandler.canElevate(player)) {
            return false;
        }
        Level level = player.m_9236_();
        BlockPos.MutableBlockPos searchPos = player.m_20183_().m_7949_().m_6625_(2).m_122032_();
        while (!(level.m_151570_((BlockPos)searchPos) || level.m_8055_((BlockPos)searchPos).m_60734_() == ModBlocks.travelAnchor && TeleportHandler.canTeleportTo((BlockGetter)level, (BlockPos)searchPos))) {
            searchPos.m_122173_(Direction.DOWN);
        }
        BlockState state = level.m_8055_((BlockPos)searchPos);
        Pair anchor = null;
        if (state.m_60734_() == ModBlocks.travelAnchor && TeleportHandler.canTeleportTo((BlockGetter)level, (BlockPos)searchPos) && !(name = ((TileTravelAnchor)ModBlocks.travelAnchor.getBlockEntity(level, target = searchPos.m_7949_())).getName()).isEmpty()) {
            anchor = Pair.of((Object)target, (Object)name);
        }
        return TeleportHandler.teleportPlayer(player, anchor, null);
    }

    @Nullable
    private static Vec3 checkTeleport(Player player, BlockPos target) {
        if (CommonConfig.fireTeleportEvent) {
            EntityTeleportEvent event = new EntityTeleportEvent((Entity)player, (double)target.m_123341_() + 0.5, (double)target.m_123342_(), (double)target.m_123343_() + 0.5);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return null;
            }
            return new Vec3(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        }
        return new Vec3((double)target.m_123341_() + 0.5, (double)target.m_123342_(), (double)target.m_123343_() + 0.5);
    }
}

