/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.rails;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Function3;
import de.melanx.utilitix.content.track.rails.BlockRail;
import de.melanx.utilitix.content.track.rails.TileControllerRail;
import de.melanx.utilitix.registration.ModItems;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.menu.GenericMenu;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

public abstract class BlockControllerRail<T extends TileControllerRail>
extends BlockRail
implements EntityBlock {
    private final BlockEntityType<T> beType = new BlockEntityType((pos, state) -> (TileControllerRail)((Object)((Object)ctor.apply(this.getTileType(), (Object)pos, (Object)state))), (Set)ImmutableSet.of((Object)((Object)this)), null);
    public final boolean reinforced;

    public BlockControllerRail(ModX mod, Function3<BlockEntityType<T>, BlockPos, BlockState, T> ctor, boolean reinforced, BlockBehaviour.Properties properties) {
        this(mod, ctor, reinforced, properties, new Item.Properties());
    }

    public BlockControllerRail(ModX mod, Function3<BlockEntityType<T>, BlockPos, BlockState, T> ctor, boolean reinforced, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, false, properties, itemProperties);
        this.reinforced = reinforced;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return this.beType.m_155264_(pos, state);
    }

    @Override
    public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
        super.registerAdditional(ctx, builder);
        builder.register(Registry.f_122907_, this.beType);
    }

    @Override
    public void initTracking(RegistrationContext ctx, Registerable.TrackingCollector builder) throws ReflectiveOperationException {
        builder.track(ForgeRegistries.BLOCK_ENTITY_TYPES, BlockControllerRail.class.getDeclaredField("beType"));
    }

    @Override
    @Nonnull
    public abstract Property<RailShape> m_7978_();

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        if (!held.m_41619_() && held.m_41720_() == ModItems.minecartTinkerer && player.m_6144_()) {
            if (!level.f_46443_ && player instanceof ServerPlayer) {
                T tile = this.getTile((BlockGetter)level, pos);
                ItemStackHandler handler = new ItemStackHandler(1, (TileControllerRail)((Object)tile)){
                    final /* synthetic */ TileControllerRail val$tile;
                    {
                        this.val$tile = tileControllerRail;
                        super(size);
                    }

                    public int getSlotLimit(int slot) {
                        return 1;
                    }

                    protected void onContentsChanged(int slot) {
                        if (slot == 0) {
                            this.val$tile.setFilterStack(this.getStackInSlot(0));
                        }
                    }
                };
                handler.setStackInSlot(0, ((TileControllerRail)((Object)tile)).getFilterStack().m_41777_());
                GenericMenu.open((ServerPlayer)((ServerPlayer)player), (IItemHandlerModifiable)handler, (Component)Component.m_237115_((String)"screen.utilitix.minecart_tinkerer"), null);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        ItemStack stack;
        if (!(!state.m_155947_() || state.m_60713_(newState.m_60734_()) && newState.m_155947_() || (stack = ((TileControllerRail)((Object)this.getTile((BlockGetter)level, pos))).getFilterStack()).m_41619_())) {
            ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5, stack.m_41777_());
            level.m_7967_((Entity)entity);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public T getTile(BlockGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be != null) {
            return (T)((Object)((TileControllerRail)be));
        }
        throw new IllegalStateException("Expected a controller rail tile entity at " + pos + ".");
    }

    public BlockEntityType<T> getTileType() {
        return this.beType;
    }

    public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        return this.reinforced ? 0.7f : 0.4f;
    }
}

