/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.rails;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

public abstract class BlockRail
extends BaseRailBlock
implements Registerable {
    protected final ModX mod;
    private final Item item;
    private final boolean hasCorners;
    private final boolean hasSlopes;

    public BlockRail(ModX mod, boolean corners, BlockBehaviour.Properties properties) {
        this(mod, corners, properties, new Item.Properties());
    }

    public BlockRail(ModX mod, boolean corners, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(!corners, properties);
        this.mod = mod;
        if (mod.tab != null) {
            itemProperties.m_41491_(mod.tab);
        }
        this.item = new BlockItem((Block)this, itemProperties);
        this.hasCorners = this.m_7978_().m_6908_().containsAll((Collection<?>)ImmutableList.of((Object)RailShape.NORTH_EAST, (Object)RailShape.NORTH_WEST, (Object)RailShape.SOUTH_EAST, (Object)RailShape.SOUTH_WEST));
        this.hasSlopes = this.m_7978_().m_6908_().containsAll((Collection<?>)ImmutableList.of((Object)RailShape.ASCENDING_NORTH, (Object)RailShape.ASCENDING_SOUTH, (Object)RailShape.ASCENDING_EAST, (Object)RailShape.ASCENDING_WEST));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
        builder.register(Registry.f_122904_, (Object)this.item);
    }

    public void initTracking(RegistrationContext ctx, Registerable.TrackingCollector builder) throws ReflectiveOperationException {
        builder.track(ForgeRegistries.ITEMS, BlockRail.class.getDeclaredField("item"));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.m_7978_()});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    @Nonnull
    public abstract Property<RailShape> m_7978_();

    @Nonnull
    public BlockState m_6843_(@Nonnull BlockState state, @Nonnull Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> {
                switch ((RailShape)state.m_61143_(this.m_7978_())) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ASCENDING_EAST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_SOUTH: 
                    case EAST_WEST: 
                }
                yield state;
            }
            case Rotation.COUNTERCLOCKWISE_90 -> {
                switch ((RailShape)state.m_61143_(this.m_7978_())) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NORTH_SOUTH: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: 
                }
                yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_WEST);
            }
            case Rotation.CLOCKWISE_90 -> {
                switch ((RailShape)state.m_61143_(this.m_7978_())) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NORTH_SOUTH: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                yield (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_EAST);
            }
            default -> state;
        };
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        RailShape railshape = (RailShape)state.m_61143_(this.m_7978_());
        block0 : switch (mirror) {
            case LEFT_RIGHT: {
                return switch (railshape) {
                    case RailShape.ASCENDING_NORTH -> (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_SOUTH);
                    case RailShape.ASCENDING_SOUTH -> (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_NORTH);
                    case RailShape.SOUTH_EAST -> (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_EAST);
                    case RailShape.SOUTH_WEST -> (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_WEST);
                    case RailShape.NORTH_WEST -> (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_WEST);
                    case RailShape.NORTH_EAST -> (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_EAST);
                    default -> super.m_6943_(state, mirror);
                };
            }
            case FRONT_BACK: {
                switch (railshape) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_WEST);
            }
        }
        return super.m_6943_(state, mirror);
    }

    public boolean m_49413_() {
        return !this.hasCorners;
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter level, BlockPos pos) {
        return this.hasSlopes;
    }
}

