/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.vanillaaiots.compat;

import de.melanx.MoreVanillaTools.items.ToolMaterials;
import de.melanx.vanillaaiots.VanillaAIOTs;
import de.melanx.vanillaaiots.compat.RegisterTiersEvent;
import de.melanx.vanillaaiots.config.ModConfig;
import de.melanx.vanillaaiots.items.BaseAiot;
import de.melanx.vanillaaiots.items.DummyItem;
import io.github.lieonlion.enderite.core.init.ToolMaterialInit;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.onvoid.copperized.common.CopperizedTiers;

public class CompatHelper {
    public static String COPPERIZED = "copperized";
    public static String ENDERITE = "lolenderite";
    public static String MOREVANILLATOOLS = "morevanillatools";
    private static final Map<String, Tier> LOADED_TIERS = new HashMap<String, Tier>();

    public static void loadTiers() {
        RegisterTiersEvent event = new RegisterTiersEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        event.getTiersByModid().forEach((modid, map) -> {
            if (ModList.get().isLoaded(modid)) {
                LOADED_TIERS.putAll((Map<String, Tier>)map);
            }
        });
        if (ModList.get().isLoaded(COPPERIZED)) {
            VanillaAIOTs.LOGGER.info(COPPERIZED + " is loaded.");
            LOADED_TIERS.put("copper", (Tier)CopperizedTiers.COPPER);
        }
        if (ModList.get().isLoaded(ENDERITE)) {
            LOADED_TIERS.put("enderite", ToolMaterialInit.ENDERITE);
        }
        if (ModList.get().isLoaded(MOREVANILLATOOLS)) {
            VanillaAIOTs.LOGGER.info(MOREVANILLATOOLS + " is loaded.");
            LOADED_TIERS.put("bone", (Tier)ToolMaterials.BONE);
            LOADED_TIERS.put("coal", (Tier)ToolMaterials.COAL);
            LOADED_TIERS.put("copper", (Tier)ToolMaterials.COPPER);
            LOADED_TIERS.put("emerald", (Tier)ToolMaterials.EMERALD);
            LOADED_TIERS.put("ender", (Tier)ToolMaterials.ENDER);
            LOADED_TIERS.put("fiery", (Tier)ToolMaterials.FIERY);
            LOADED_TIERS.put("glowstone", (Tier)ToolMaterials.GLOWSTONE);
            LOADED_TIERS.put("lapis", (Tier)ToolMaterials.LAPIS);
            LOADED_TIERS.put("nether", (Tier)ToolMaterials.NETHER);
            LOADED_TIERS.put("obsidian", (Tier)ToolMaterials.OBSIDIAN);
            LOADED_TIERS.put("paper", (Tier)ToolMaterials.PAPER);
            LOADED_TIERS.put("prismarine", (Tier)ToolMaterials.PRISMARINE);
            LOADED_TIERS.put("quartz", (Tier)ToolMaterials.QUARTZ);
            LOADED_TIERS.put("redstone", (Tier)ToolMaterials.REDSTONE);
            LOADED_TIERS.put("slime", (Tier)ToolMaterials.SLIME);
        }
    }

    public static Item makeItem(String modid, float attackDamageModifier, float attackSpeedModifier, String tier, Item.Properties properties) {
        return CompatHelper.makeItem(List.of(modid), attackDamageModifier, attackSpeedModifier, tier, properties);
    }

    public static Item makeItem(List<String> modids, float attackDamageModifier, float attackSpeedModifier, String tier, Item.Properties properties) {
        if (LOADED_TIERS.containsKey(tier)) {
            return new BaseAiot(attackDamageModifier, attackSpeedModifier, CompatHelper.createTier(CompatHelper.getTierFor(tier)), properties);
        }
        return new DummyItem(modids);
    }

    public static Tier getTierFor(String material) {
        return LOADED_TIERS.getOrDefault(material.toLowerCase(Locale.ROOT), DummyItem.DUMMY_TIER);
    }

    public static int getDurabilityFor(String tier) {
        return CompatHelper.getTierFor(tier).m_6609_();
    }

    public static Ingredient getIngredientByIds(ResourceLocation ... ids) {
        HashSet<Ingredient> ingredients = new HashSet<Ingredient>();
        for (ResourceLocation id : ids) {
            if (id.m_135827_().startsWith("#")) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(id.m_135827_().replace("#", ""), id.m_135815_()));
                ingredients.add(Ingredient.m_204132_((TagKey)tag));
                continue;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (item == null) {
                VanillaAIOTs.LOGGER.info("Item doesn't exist: " + id);
            }
            ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }
        return ingredients.isEmpty() ? Ingredient.f_43901_ : Ingredient.merge(ingredients);
    }

    public static boolean isLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    public static Tier createTier(final Tier base) {
        return new Tier(){

            public int m_6609_() {
                return (int)((float)base.m_6609_() * ModConfig.durabilityModifier);
            }

            public float m_6624_() {
                return base.m_6624_();
            }

            public float m_6631_() {
                return base.m_6631_();
            }

            public int m_6604_() {
                return base.m_6604_();
            }

            public int m_6601_() {
                return base.m_6601_();
            }

            @Nonnull
            public Ingredient m_6282_() {
                return base.m_6282_();
            }
        };
    }

    public record LoadedTier(String name, Tier tier) {
    }
}

