/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.vanillaaiots.tools;

import de.melanx.vanillaaiots.compat.CompatHelper;
import de.melanx.vanillaaiots.config.ConfigureableMaterial;
import de.melanx.vanillaaiots.config.ModConfig;
import de.melanx.vanillaaiots.data.AIOTTags;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import org.moddingx.libx.util.lazy.LazyValue;

public enum ToolMaterials implements Tier
{
    WOODEN(ModConfig.ToolValues.wood, Tiers.WOOD.m_6609_(), () -> Ingredient.m_204132_((TagKey)ItemTags.f_13168_)),
    STONE(ModConfig.ToolValues.stone, Tiers.STONE.m_6609_(), () -> Ingredient.m_204132_((TagKey)Tags.Items.COBBLESTONE)),
    IRON(ModConfig.ToolValues.iron, Tiers.IRON.m_6609_(), () -> Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON)),
    GOLDEN(ModConfig.ToolValues.gold, Tiers.GOLD.m_6609_(), () -> Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD)),
    DIAMOND(ModConfig.ToolValues.diamond, Tiers.DIAMOND.m_6609_(), () -> Ingredient.m_204132_((TagKey)Tags.Items.GEMS_DIAMOND)),
    NETHERITE(ModConfig.ToolValues.netherite, Tiers.NETHERITE.m_6609_(), () -> Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_NETHERITE)),
    BONE("bone", () -> Ingredient.m_204132_((TagKey)Tags.Items.BONES)),
    COAL("coal", () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_})),
    COPPER("copper", () -> Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER)),
    EMERALD("emerald", () -> Ingredient.m_204132_((TagKey)Tags.Items.GEMS_EMERALD)),
    ENDER("ender", () -> Ingredient.m_204132_((TagKey)Tags.Items.ENDER_PEARLS)),
    FIERY("fiery", () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42258_})),
    GLOWSTONE("glowstone", () -> Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_GLOWSTONE)),
    LAPIS("lapis", () -> Ingredient.m_204132_((TagKey)Tags.Items.GEMS_LAPIS)),
    NETHER("nether", () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42095_})),
    OBSIDIAN("obsidian", () -> Ingredient.m_204132_((TagKey)Tags.Items.OBSIDIAN)),
    PAPER("paper", () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_})),
    PRISMARINE("prismarine", () -> Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_PRISMARINE)),
    QUARTZ("quartz", () -> Ingredient.m_204132_((TagKey)Tags.Items.GEMS_QUARTZ)),
    REDSTONE("redstone", () -> Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE)),
    SLIME("slime", () -> Ingredient.m_204132_((TagKey)Tags.Items.SLIMEBALLS)),
    ENDERITE("enderite", () -> CompatHelper.isLoaded(CompatHelper.ENDERITE) ? CompatHelper.getIngredientByIds(new ResourceLocation(CompatHelper.ENDERITE, "enderite_ingot")) : Ingredient.f_43901_);

    private final ConfigureableMaterial material;
    private final int durability;
    private final LazyValue<Ingredient> repairIngredient;

    private ToolMaterials(String material, Supplier<Ingredient> repairIngredient) {
        int baseDurability = CompatHelper.getDurabilityFor(material);
        this.material = ConfigureableMaterial.of(CompatHelper.getTierFor(material));
        this.durability = (int)((float)baseDurability * ModConfig.durabilityModifier);
        this.repairIngredient = new LazyValue(repairIngredient);
    }

    private ToolMaterials(ConfigureableMaterial material, int baseDurability, Supplier<Ingredient> repairIngredient) {
        this.material = material;
        this.durability = (int)((float)baseDurability * ModConfig.durabilityModifier);
        this.repairIngredient = new LazyValue(repairIngredient);
    }

    public int m_6609_() {
        return this.durability;
    }

    public float m_6624_() {
        return this.material.speed();
    }

    public float m_6631_() {
        return this.material.attackDamageBonus();
    }

    public int m_6604_() {
        return this.material.harvestLevel();
    }

    public int m_6601_() {
        return this.material.enchantmentValue();
    }

    @Nonnull
    public Ingredient m_6282_() {
        return (Ingredient)this.repairIngredient.get();
    }

    public TagKey<Block> getTag() {
        return AIOTTags.MINEABLE_WITH_AIOT;
    }
}

