/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.proxy;

import it.zerono.mods.zerocore.internal.InternalCommand;
import it.zerono.mods.zerocore.internal.network.ErrorReportMessage;
import it.zerono.mods.zerocore.internal.network.Network;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;

public interface IProxy {
    public Optional<Level> getClientWorld();

    public Optional<Player> getClientPlayer();

    public void markBlockRangeForRenderUpdate(BlockPos var1, BlockPos var2);

    public void sendPlayerStatusMessage(Player var1, Component var2);

    public void addResourceReloadListener(PreparableReloadListener var1);

    default public long getLastRenderTime() {
        return 0L;
    }

    default public void reportErrorToPlayer(@Nullable Player player, @Nullable BlockPos position, Component ... messages) {
        if (player instanceof ServerPlayer) {
            Network.HANDLER.sendToPlayer(ErrorReportMessage.create(position, messages), (ServerPlayer)player);
        }
    }

    default public void reportErrorToPlayer(@Nullable Player player, @Nullable BlockPos position, List<Component> messages) {
        if (player instanceof ServerPlayer) {
            Network.HANDLER.sendToPlayer(ErrorReportMessage.create(position, messages), (ServerPlayer)player);
        }
    }

    default public void displayErrorToPlayer(@Nullable BlockPos position, Component ... messages) {
    }

    default public void displayErrorToPlayer(@Nullable BlockPos position, List<Component> messages) {
    }

    public void clearErrorReport();

    @Nullable
    public RecipeManager getRecipeManager();

    default public void handleInternalCommand(InternalCommand command, CompoundTag data, NetworkDirection direction) {
    }

    public void debugUngrabMouse();
}

