/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render.vertexuploader;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import it.zerono.mods.zerocore.lib.client.render.IVertexSequence;
import it.zerono.mods.zerocore.lib.client.render.IVertexSource;
import it.zerono.mods.zerocore.lib.client.render.vertexuploader.ISourceAdapter;
import it.zerono.mods.zerocore.lib.client.render.vertexuploader.IUploader;
import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.data.gfx.LightMap;
import it.zerono.mods.zerocore.lib.data.gfx.UV;
import java.util.List;
import java.util.Map;

public class VertexUploader {
    public static final VertexUploader INSTANCE = new VertexUploader();
    private static final ISourceAdapter DEFAULT_ADAPTER = new ISourceAdapter(){};
    private final Map<VertexFormat, IUploader> _uploaders = Maps.newHashMapWithExpectedSize((int)2);

    public void upload(VertexFormat format, VertexConsumer builder, IVertexSource source) {
        this.upload(format, builder, source, DEFAULT_ADAPTER);
    }

    public void upload(VertexFormat format, VertexConsumer builder, IVertexSequence sequence) {
        this.upload(format, builder, sequence, DEFAULT_ADAPTER);
    }

    public void upload(VertexFormat format, VertexConsumer builder, List<IVertexSource> sources) {
        this.upload(format, builder, sources, DEFAULT_ADAPTER);
    }

    public void upload(VertexFormat format, VertexConsumer builder, IVertexSource source, ISourceAdapter adapter) {
        this.getUploaderFor(format).upload(builder, source, adapter);
    }

    public void upload(VertexFormat format, VertexConsumer builder, IVertexSequence sequence, ISourceAdapter adapter) {
        this.upload(format, builder, sequence.getVertices(), adapter);
    }

    public void upload(VertexFormat format, VertexConsumer builder, List<IVertexSource> sources, ISourceAdapter adapter) {
        IUploader uploader = this.getUploaderFor(format);
        sources.forEach(source -> uploader.upload(builder, (IVertexSource)source, adapter));
    }

    private VertexUploader() {
        this._uploaders.put(DefaultVertexFormat.f_85811_, VertexUploader::blockUploader);
        this._uploaders.put(DefaultVertexFormat.f_85812_, VertexUploader::entityUploader);
    }

    private IUploader getUploaderFor(VertexFormat format) {
        return this._uploaders.getOrDefault(format, VertexUploader::fallBackUploader);
    }

    private static void fallBackUploader(VertexConsumer builder, IVertexSource source, ISourceAdapter adapter) {
        Vector3d pos = adapter.getPos(source);
        Vector3f normal = adapter.getNormal(source);
        UV uv = adapter.getUV(source);
        Colour colour = adapter.getColour(source);
        LightMap overlay = adapter.getOverlayMap(source);
        LightMap light = adapter.getLightMap(source);
        builder.m_5483_(pos.X, pos.Y, pos.Z);
        if (null != colour) {
            builder.m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
        }
        if (null != uv) {
            builder.m_7421_(uv.U, uv.V);
        }
        if (null != overlay) {
            builder.m_7122_(overlay.U, overlay.V);
        }
        if (null != light) {
            builder.m_7120_(light.U, light.V);
        }
        if (null != normal) {
            builder.m_5601_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
        }
        builder.m_5752_();
    }

    private static void blockUploader(VertexConsumer builder, IVertexSource source, ISourceAdapter adapter) {
        Vector3d pos = adapter.getPos(source);
        Vector3f normal = adapter.getNormal(source);
        UV uv = adapter.getUV(source);
        Colour colour = adapter.getColour(source);
        LightMap light = adapter.getLightMap(source);
        builder.m_5483_(pos.X, pos.Y, pos.Z).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_7421_(uv.U, uv.V).m_7120_(light.U, light.V).m_5601_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
    }

    private static void entityUploader(VertexConsumer builder, IVertexSource source, ISourceAdapter adapter) {
        Vector3d pos = adapter.getPos(source);
        Vector3f normal = adapter.getNormal(source);
        UV uv = adapter.getUV(source);
        Colour colour = adapter.getColour(source);
        LightMap overlay = adapter.getOverlayMap(source);
        LightMap light = adapter.getLightMap(source);
        builder.m_5483_(pos.X, pos.Y, pos.Z).m_6122_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).m_7421_(uv.U, uv.V).m_7122_(overlay.U, overlay.V).m_7120_(light.U, light.V).m_5601_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
    }
}

