/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.geometry;

import it.zerono.mods.zerocore.lib.data.geometry.Point;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class Rectangle {
    public static final Rectangle ZERO = new Rectangle();
    public final Point Origin;
    public final int Width;
    public final int Height;
    private Direction.Plane _layout;

    public Rectangle(int x, int y, int width, int height) {
        this.Origin = new Point(x, y);
        this.Width = Math.abs(width);
        this.Height = Math.abs(height);
    }

    public Rectangle(Point origin, int width, int height) {
        this.Origin = new Point(origin);
        this.Width = Math.abs(width);
        this.Height = Math.abs(height);
    }

    public Rectangle(Rectangle other) {
        this(other.Origin, other.Width, other.Height);
    }

    public static Rectangle syncDataFrom(CompoundTag data) {
        if (data.m_128441_("rx") && data.m_128441_("ry") && data.m_128441_("rw") && data.m_128441_("rh")) {
            return new Rectangle(data.m_128451_("rx"), data.m_128451_("ry"), data.m_128451_("rw"), data.m_128451_("rh"));
        }
        return ZERO;
    }

    public CompoundTag syncDataTo(CompoundTag data) {
        data.m_128405_("rx", this.Origin.X);
        data.m_128405_("ry", this.Origin.Y);
        data.m_128405_("rw", this.Width);
        data.m_128405_("rh", this.Height);
        return data;
    }

    public int getX1() {
        return this.Origin.X;
    }

    public int getY1() {
        return this.Origin.Y;
    }

    public int getX2() {
        return this.Origin.X + this.Width;
    }

    public int getY2() {
        return this.Origin.Y + this.Height;
    }

    public Direction.Plane getLayout() {
        if (null == this._layout) {
            this._layout = this.Width >= this.Height ? Direction.Plane.HORIZONTAL : Direction.Plane.VERTICAL;
        }
        return this._layout;
    }

    public Rectangle offset(int offsetX, int offsetY) {
        return new Rectangle(this.Origin.X + offsetX, this.Origin.Y + offsetY, this.Width, this.Height);
    }

    public Rectangle expand(int deltaX, int deltaY) {
        if (0 == deltaX && 0 == deltaY) {
            return this;
        }
        int width = this.Width;
        int height = this.Height;
        if (deltaX > 0) {
            width += deltaX;
        }
        if (deltaY > 0) {
            height += deltaY;
        }
        return new Rectangle(this.Origin.X, this.Origin.Y, width, height);
    }

    public Rectangle shrink(int deltaX, int deltaY) {
        if (0 == deltaX && 0 == deltaY) {
            return this;
        }
        int width = this.Width;
        int height = this.Height;
        if (deltaX > 0) {
            width = Math.max(0, width - deltaX);
        }
        if (deltaY > 0) {
            height = Math.max(0, height - deltaY);
        }
        return new Rectangle(this.Origin.X, this.Origin.Y, width, height);
    }

    public Rectangle inset(int horizontal, int vertical) {
        return new Rectangle(this.Origin.X + horizontal, this.Origin.Y + vertical, Math.max(0, this.Width - horizontal * 2), Math.max(0, this.Height - vertical * 2));
    }

    public Rectangle wrap(int x, int y) {
        Rectangle r = this;
        if (x < r.Origin.X) {
            r = r.expand(x - r.Origin.X, 0);
        } else if (x >= r.Origin.X + r.Width) {
            r = r.expand(x - r.Origin.X - r.Width + 1, 0);
        }
        if (y < r.Origin.Y) {
            r = r.expand(0, y - r.Origin.Y);
        } else if (y >= r.Origin.Y + r.Height) {
            r = r.expand(0, y - r.Origin.Y - r.Height + 1);
        }
        return r;
    }

    public Rectangle wrap(Rectangle other) {
        return this.wrap(other.getX1(), other.getY1()).wrap(other.getX2(), other.getY2());
    }

    public Rectangle fit(Rectangle other) {
        int x = this.Origin.X;
        int y = this.Origin.Y;
        int w = this.Width;
        int h = this.Height;
        if (w > other.Width) {
            w = other.Width;
            x = other.Origin.X;
        } else if (this.getX2() > other.getX2()) {
            x -= this.getX2() - other.getX2();
        } else if (this.getX1() < other.getX1()) {
            x = other.getX1();
        }
        if (h > other.Height) {
            h = other.Height;
            y = other.Origin.Y;
        } else if (this.getY2() > other.getY2()) {
            y -= this.getY2() - other.getY2();
        } else if (this.getY1() < other.getY1()) {
            y = other.getY1();
        }
        return new Rectangle(x, y, w, h);
    }

    public boolean contains(int x, int y) {
        int tw = this.Width;
        int th = this.Height;
        int tx = this.Origin.X;
        int ty = this.Origin.Y;
        if (x < tx || y < ty) {
            return false;
        }
        th += ty;
        return !((tw += tx) >= tx && tw <= x || th >= ty && th <= y);
    }

    public boolean contains(Point p) {
        return this.contains(p.X, p.Y);
    }

    public boolean contains(double x, double y) {
        return this.contains((int)x, (int)y);
    }

    public boolean contains(int x, int y, int width, int height) {
        int tw = this.Width;
        int th = this.Height;
        if ((tw | th | width | height) < 0) {
            return false;
        }
        int tx = this.Origin.X;
        int ty = this.Origin.Y;
        if (x < tx || y < ty) {
            return false;
        }
        tw += tx;
        if ((width += x) <= x ? tw >= tx || width > tw : tw >= tx && width > tw) {
            return false;
        }
        th += ty;
        if ((height += y) <= y) {
            return th < ty && height <= th;
        }
        return th < ty || height <= th;
    }

    public boolean contains(Rectangle r) {
        return this.contains(r.Origin.X, r.Origin.Y, r.Width, r.Height);
    }

    public boolean intersects(Rectangle other) {
        return other.Origin.X + other.Width > this.Origin.X && other.Origin.X < this.Origin.X + this.Width && other.Origin.Y + other.Height > this.Origin.Y && other.Origin.Y < this.Origin.Y + this.Height;
    }

    public boolean equals(Object other) {
        if (other instanceof Rectangle) {
            Rectangle r = (Rectangle)other;
            return this.Origin.equals(r.Origin) && this.Width == r.Width && this.Height == r.Height;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.Origin, this.Width, this.Height);
    }

    public String toString() {
        return String.format("Rectangle (%d, %d) [%d x %d]", this.Origin.X, this.Origin.Y, this.Width, this.Height);
    }

    private Rectangle() {
        this.Origin = Point.ZERO;
        this.Height = 0;
        this.Width = 0;
    }
}

