/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.datagen.LootTableType;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;

public class BaseLootTableProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final LootTableType _type;
    private final DataGenerator _generator;
    private final Map<ResourceLocation, LootTable.Builder> _tables;

    protected BaseLootTableProvider(LootTableType type, DataGenerator dataGenerator) {
        this._type = type;
        this._generator = dataGenerator;
        this._tables = Maps.newHashMap();
    }

    public LootTableType getType() {
        return this._type;
    }

    protected void generateTables() {
    }

    protected void add(Block block, LootTable.Builder builder) {
        this.add(CodeHelper.getObjectId(block), builder);
    }

    protected void add(ResourceLocation id, LootTable.Builder builder) {
        if (null != this._tables.put(id, builder)) {
            Log.LOGGER.error(Log.CORE, "Loot table provider - {} table {} already exist!", (Object)this.getType(), (Object)id);
        }
    }

    protected void addEmpty(ResourceLocation id) {
        this.add(id, LootTable.m_79147_());
    }

    public void m_213708_(CachedOutput cache) {
        this.generateTables();
        this._tables.forEach((id, builder) -> this.writeTable(cache, (ResourceLocation)id, builder.m_79165_(this.getType().getParameters()).m_79167_()));
    }

    public String m_6055_() {
        return "";
    }

    private void writeTable(CachedOutput cache, ResourceLocation id, LootTable table) {
        Path path = this._generator.m_123916_().resolve("data/" + id.m_135827_() + "/loot_tables/" + this.getType().getSubFolderName() + "/" + id.m_135815_() + ".json");
        try {
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)LootTables.m_79200_((LootTable)table), (Path)path);
        }
        catch (IOException ex) {
            Log.LOGGER.error(Log.CORE, "Loot table provider - couldn't write tables at {}", (Object)path, (Object)ex);
        }
    }
}

