/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.render;

import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.render.ColorRef;
import appeng.client.guidebook.render.LightDarkMode;
import appeng.client.guidebook.render.RenderContext;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;

public record SimpleRenderContext(LytRect viewport, PoseStack poseStack, LightDarkMode lightDarkMode) implements RenderContext
{
    @Override
    public int resolveColor(ColorRef ref) {
        if (ref.symbolic != null) {
            return ref.symbolic.resolve(this.lightDarkMode);
        }
        return ref.concrete;
    }

    @Override
    public void fillRect(LytRect rect, ColorRef topLeft, ColorRef topRight, ColorRef bottomRight, ColorRef bottomLeft) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = this.poseStack.m_85850_().m_85861_();
        boolean z = false;
        builder.m_85982_(matrix, (float)rect.right(), (float)rect.y(), 0.0f).m_193479_(this.resolveColor(topRight)).m_5752_();
        builder.m_85982_(matrix, (float)rect.x(), (float)rect.y(), 0.0f).m_193479_(this.resolveColor(topLeft)).m_5752_();
        builder.m_85982_(matrix, (float)rect.x(), (float)rect.bottom(), 0.0f).m_193479_(this.resolveColor(bottomLeft)).m_5752_();
        builder.m_85982_(matrix, (float)rect.right(), (float)rect.bottom(), 0.0f).m_193479_(this.resolveColor(bottomRight)).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    @Override
    public void fillTexturedRect(LytRect rect, AbstractTexture texture, ColorRef topLeft, ColorRef topRight, ColorRef bottomRight, ColorRef bottomLeft, float u0, float v0, float u1, float v1) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157453_((int)0, (int)texture.m_117963_());
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        Matrix4f matrix = this.poseStack.m_85850_().m_85861_();
        boolean z = false;
        builder.m_85982_(matrix, (float)rect.right(), (float)rect.y(), 0.0f).m_7421_(u1, v0).m_193479_(this.resolveColor(topRight)).m_5752_();
        builder.m_85982_(matrix, (float)rect.x(), (float)rect.y(), 0.0f).m_7421_(u0, v0).m_193479_(this.resolveColor(topLeft)).m_5752_();
        builder.m_85982_(matrix, (float)rect.x(), (float)rect.bottom(), 0.0f).m_7421_(u0, v1).m_193479_(this.resolveColor(bottomLeft)).m_5752_();
        builder.m_85982_(matrix, (float)rect.right(), (float)rect.bottom(), 0.0f).m_7421_(u1, v1).m_193479_(this.resolveColor(bottomRight)).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
    }

    @Override
    public void fillTriangle(Vec2 p1, Vec2 p2, Vec2 p3, ColorRef color) {
        int resolvedColor = this.resolveColor(color);
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = this.poseStack.m_85850_().m_85861_();
        boolean z = false;
        builder.m_85982_(matrix, p1.f_82470_, p1.f_82471_, 0.0f).m_193479_(resolvedColor).m_5752_();
        builder.m_85982_(matrix, p2.f_82470_, p2.f_82471_, 0.0f).m_193479_(resolvedColor).m_5752_();
        builder.m_85982_(matrix, p3.f_82470_, p3.f_82471_, 0.0f).m_193479_(resolvedColor).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    @Override
    public void renderItem(ItemStack stack, int x, int y, int z, float width, float height) {
        boolean flatLighting;
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        BakedModel model = itemRenderer.m_174264_(stack, null, null, 0);
        textureManager.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.poseStack.m_85836_();
        this.poseStack.m_85837_((double)x, (double)y, (double)(z + 1));
        this.poseStack.m_85837_((double)(width / 2.0f), (double)(height / 2.0f), 0.0);
        this.poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        this.poseStack.m_85841_(width, height, 1.0f);
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flatLighting = !model.m_7547_();
        if (flatLighting) {
            Lighting.m_84930_();
        } else {
            Lighting.m_166384_();
        }
        itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GUI, false, this.poseStack, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_, model);
        buffers.m_109911_();
        RenderSystem.m_69482_();
        if (flatLighting) {
            Lighting.m_84931_();
        }
        this.poseStack.m_85849_();
    }
}

