/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.behaviors.GenericSlotCapacities;
import appeng.api.client.AEStackRendering;
import appeng.api.client.IAEStackRenderHandler;
import appeng.api.client.StorageCellModels;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.parts.automation.StackWorldBehaviors;
import gripe._90.arseng.definition.ArsEngBlocks;
import gripe._90.arseng.definition.ArsEngCapabilities;
import gripe._90.arseng.definition.ArsEngConfig;
import gripe._90.arseng.definition.ArsEngCore;
import gripe._90.arseng.definition.ArsEngItems;
import gripe._90.arseng.item.PortableSourceCellItem;
import gripe._90.arseng.me.cell.CreativeSourceCellHandler;
import gripe._90.arseng.me.cell.SourceCellHandler;
import gripe._90.arseng.me.client.SourceRenderer;
import gripe._90.arseng.me.key.SourceKey;
import gripe._90.arseng.me.key.SourceKeyType;
import gripe._90.arseng.me.strategy.SourceContainerItemStrategy;
import gripe._90.arseng.me.strategy.SourceExternalStorageStrategy;
import gripe._90.arseng.me.strategy.SourceStorageExportStrategy;
import gripe._90.arseng.me.strategy.SourceStorageImportStrategy;
import gripe._90.arseng.part.SpellP2PTunnelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="arseng")
public class ArsEnergistique {
    public ArsEnergistique() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ArsEngConfig.SPEC);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ArsEngItems::register);
        bus.addListener(ArsEngBlocks::register);
        bus.addListener(SourceKeyType::register);
        StorageCells.addCellHandler((ICellHandler)SourceCellHandler.INSTANCE);
        StorageCells.addCellHandler((ICellHandler)CreativeSourceCellHandler.INSTANCE);
        bus.addListener(ArsEngCapabilities::register);
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, ArsEngCapabilities::attach);
        StackWorldBehaviors.registerImportStrategy((AEKeyType)SourceKeyType.TYPE, SourceStorageImportStrategy::new);
        StackWorldBehaviors.registerExportStrategy((AEKeyType)SourceKeyType.TYPE, SourceStorageExportStrategy::new);
        StackWorldBehaviors.registerExternalStorageStrategy((AEKeyType)SourceKeyType.TYPE, SourceExternalStorageStrategy::new);
        ContainerItemStrategy.register((AEKeyType)SourceKeyType.TYPE, SourceKey.class, (ContainerItemStrategy)new SourceContainerItemStrategy());
        GenericSlotCapacities.register((AEKeyType)SourceKeyType.TYPE, (Long)10000L);
        bus.addListener(ArsEngItems::initP2PAttunement);
        MinecraftForge.EVENT_BUS.addListener(SpellP2PTunnelPart::onSpellHit);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            Client.init();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void init() {
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            bus.addListener(SourceCellHandler::initLED);
            bus.addListener(PortableSourceCellItem::initColours);
            AEStackRendering.register((AEKeyType)SourceKeyType.TYPE, SourceKey.class, (IAEStackRenderHandler)new SourceRenderer());
            ResourceLocation driveCell = ArsEngCore.makeId("block/source_drive_cell");
            ArsEngItems.getCells().forEach(cell -> StorageCellModels.registerModel((ItemLike)cell, (ResourceLocation)driveCell));
            ArsEngItems.getPortables().forEach(portable -> StorageCellModels.registerModel((ItemLike)portable, (ResourceLocation)driveCell));
            StorageCellModels.registerModel(ArsEngItems.CREATIVE_SOURCE_CELL, (ResourceLocation)driveCell);
        }
    }
}

