/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.me.strategy;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.GenericStack;
import com.google.common.base.Preconditions;
import com.hollingsworth.arsnouveau.common.block.CreativeSourceJar;
import com.hollingsworth.arsnouveau.common.block.SourceJar;
import gripe._90.arseng.me.key.SourceKey;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SourceContainerItemStrategy
implements ContainerItemStrategy<SourceKey, Context> {
    public static final int MAX_SOURCE = 10000;

    private boolean isSourceJar(ItemStack stack) {
        BlockItem blockItem;
        Item item;
        return stack != null && (item = stack.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof SourceJar;
    }

    private boolean isCreativeSourceJar(ItemStack stack) {
        return this.isSourceJar(stack) && ((BlockItem)stack.m_41720_()).m_40614_() instanceof CreativeSourceJar;
    }

    private int getSource(ItemStack sourceJar) {
        Preconditions.checkArgument((boolean)this.isSourceJar(sourceJar));
        if (this.isCreativeSourceJar(sourceJar)) {
            return 10000;
        }
        if (!sourceJar.m_41782_()) {
            return 0;
        }
        return sourceJar.m_41784_().m_128469_("BlockEntityTag").m_128451_("source");
    }

    private void changeSource(int amount, ItemStack sourceJar) {
        Preconditions.checkArgument((boolean)this.isSourceJar(sourceJar));
        if (this.isCreativeSourceJar(sourceJar)) {
            return;
        }
        CompoundTag beTag = sourceJar.m_41784_().m_128469_("BlockEntityTag");
        beTag.m_128405_("source", Math.min(10000, Math.max(this.getSource(sourceJar) + amount, 0)));
        beTag.m_128385_("items", new int[0]);
        sourceJar.m_41784_().m_128365_("BlockEntityTag", (Tag)beTag);
    }

    @Nullable
    public GenericStack getContainedStack(ItemStack stack) {
        return this.isSourceJar(stack) ? new GenericStack(SourceKey.KEY, (long)this.getSource(stack)) : null;
    }

    @Nullable
    public Context findCarriedContext(Player player, AbstractContainerMenu menu) {
        ItemStack carried = menu.m_142621_();
        return this.isSourceJar(carried) ? new CarriedContext(player, menu) : null;
    }

    @Nullable
    public Context findPlayerSlotContext(Player player, int slot) {
        ItemStack carried = player.m_150109_().m_8020_(slot);
        return this.isSourceJar(carried) ? new PlayerInvContext(player, slot) : null;
    }

    public long extract(Context context, SourceKey what, long amount, Actionable mode) {
        ItemStack stackCopy = context.getStack().m_41777_();
        stackCopy.m_41764_(1);
        int extracted = (int)Math.min(amount, (long)this.getSource(stackCopy));
        if (extracted > 0 && mode == Actionable.MODULATE) {
            this.changeSource(-extracted, stackCopy);
            context.getStack().m_41774_(1);
            context.addOverflow(stackCopy);
        }
        return extracted;
    }

    public long insert(Context context, SourceKey what, long amount, Actionable mode) {
        ItemStack stackCopy = context.getStack().m_41777_();
        stackCopy.m_41764_(1);
        int inserted = (int)Math.min(amount, (long)(10000 - this.getSource(stackCopy)));
        if (inserted > 0 && mode == Actionable.MODULATE) {
            this.changeSource(inserted, stackCopy);
            context.getStack().m_41774_(1);
            context.addOverflow(stackCopy);
        }
        return inserted;
    }

    public void playFillSound(Player player, SourceKey what) {
    }

    public void playEmptySound(Player player, SourceKey what) {
    }

    @Nullable
    public GenericStack getExtractableContent(Context context) {
        return this.getContainedStack(context.getStack());
    }

    private record CarriedContext(Player player, AbstractContainerMenu menu) implements Context
    {
        @Override
        public ItemStack getStack() {
            return this.menu.m_142621_();
        }

        @Override
        public void addOverflow(ItemStack stack) {
            if (this.menu.m_142621_().m_41619_()) {
                this.menu.m_142503_(stack);
            } else {
                this.player.m_150109_().m_150079_(stack);
            }
        }
    }

    private record PlayerInvContext(Player player, int slot) implements Context
    {
        @Override
        public ItemStack getStack() {
            return this.player.m_150109_().m_8020_(this.slot);
        }

        @Override
        public void addOverflow(ItemStack stack) {
            this.player.m_150109_().m_150079_(stack);
        }
    }

    public static interface Context {
        public ItemStack getStack();

        public void addOverflow(ItemStack var1);
    }
}

