/*
 * Decompiled with CFR 0.152.
 */
package artifacts;

import artifacts.ArtifactsClient;
import artifacts.common.capability.SwimHandler;
import artifacts.common.config.ModConfig;
import artifacts.common.init.ModEntityTypes;
import artifacts.common.init.ModFeatures;
import artifacts.common.init.ModItems;
import artifacts.common.init.ModLootConditions;
import artifacts.common.init.ModLootModifiers;
import artifacts.common.init.ModSoundEvents;
import artifacts.common.network.NetworkHandler;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="artifacts")
public class Artifacts {
    public static final String MODID = "artifacts";

    public Artifacts() {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ArtifactsClient::new);
        ModConfig.registerCommon();
        SwimHandler.init();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.ITEMS.register(modBus);
        ModEntityTypes.ENTITY_TYPES.register(modBus);
        ModSoundEvents.SOUND_EVENTS.register(modBus);
        ModFeatures.PLACEMENT_MODIFIERS.register(modBus);
        ModFeatures.FEATURES.register(modBus);
        ModFeatures.CONFIGURED_FEATURES.register(modBus);
        ModFeatures.PLACED_FEATURES.register(modBus);
        ModLootModifiers.LOOT_MODIFIERS.register(modBus);
        ModLootConditions.LOOT_CONDITIONS.register(modBus);
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::enqueueIMC);
        modBus.addListener(ModEntityTypes::registerAttributes);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        ModConfig.registerServer();
        event.enqueueWork(() -> {
            ModFeatures.register();
            NetworkHandler.register();
        });
    }

    public void enqueueIMC(InterModEnqueueEvent event) {
        SlotTypePreset[] types;
        for (SlotTypePreset type : types = new SlotTypePreset[]{SlotTypePreset.HEAD, SlotTypePreset.NECKLACE, SlotTypePreset.BELT}) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> type.getMessageBuilder().build());
        }
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HANDS.getMessageBuilder().size(2).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("feet").priority(220).icon(InventoryMenu.f_39696_).build());
    }
}

