/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.config;

import com.cupboard.config.ICommonConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class CommonConfiguration
implements ICommonConfig {
    public boolean enablePrediction = true;
    public int predictiondidstanceoffset = -2;
    public int predictionarea = 7;
    public boolean enablePreGen = true;
    public int preGenArea = 7;
    public boolean enableLazyChunkloading = true;
    public double lazyloadingspeed = 0.7;
    public boolean enableFasterChunkLoading = true;
    public boolean debugLogging = false;

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry3 = new JsonObject();
        entry3.addProperty("desc:", "Enables predictive chunkloading, which predicts player movement and preloads an area in movement direction: default:true");
        entry3.addProperty("enablePrediction", Boolean.valueOf(this.enablePrediction));
        root.add("enablePrediction", (JsonElement)entry3);
        JsonObject entry = new JsonObject();
        entry.addProperty("desc:", "Offset to the distance(based on simulation distance) at which chunk prediction starts pre-loading(circular): default:-2 chunks");
        entry.addProperty("predictiondidstanceoffset", (Number)this.predictiondidstanceoffset);
        root.add("predictiondidstanceoffset", (JsonElement)entry);
        JsonObject entry2 = new JsonObject();
        entry2.addProperty("desc:", "Size of the area marked for preloading: default:7 chunks, max: 32, min: 2");
        entry2.addProperty("predictionarea", (Number)this.predictionarea);
        root.add("predictionarea", (JsonElement)entry2);
        JsonObject entry9 = new JsonObject();
        entry9.addProperty("desc:", "Enables predictive, async pre-gen far ahead of the player, to generate nonexisting chunks early so they load in time, requires enablePrediction: default:true");
        entry9.addProperty("enablePreGen", Boolean.valueOf(this.enablePreGen));
        root.add("enablePreGen", (JsonElement)entry9);
        JsonObject entry10 = new JsonObject();
        entry10.addProperty("desc:", "Size of the area marked for pregeneration: default:7 chunks, min 1, max 32");
        entry10.addProperty("preGenArea", (Number)this.preGenArea);
        root.add("preGenArea", (JsonElement)entry10);
        JsonObject entry5 = new JsonObject();
        entry5.addProperty("desc:", "Enables lazy chunkloading around the player, which makes the area loaded directly around the player react more slowly to player position changes.(Improves server performance, less chunks are loaded/unlaoded frequently) : default:true");
        entry5.addProperty("enableLazyChunkloading", Boolean.valueOf(this.enableLazyChunkloading));
        root.add("enableLazyChunkloading", (JsonElement)entry5);
        JsonObject entry6 = new JsonObject();
        entry6.addProperty("desc:", "Set the speed of lazy loading, increasing this makes the lazy chunk loading gets less lazy and react to player position changes faster: default:0.7");
        entry6.addProperty("lazyloadingspeed", (Number)this.lazyloadingspeed);
        root.add("lazyloadingspeed", (JsonElement)entry6);
        JsonObject entry7 = new JsonObject();
        entry7.addProperty("desc:", "Enables faster chunk loading, which slightly improves the general chunk loading speed: default:true");
        entry7.addProperty("enableFasterChunkLoading", Boolean.valueOf(this.enableFasterChunkLoading));
        root.add("enableFasterChunkLoading", (JsonElement)entry7);
        JsonObject entry8 = new JsonObject();
        entry8.addProperty("desc:", "Enables debug logging to show chunk loading changes: default:false");
        entry8.addProperty("debugLogging", Boolean.valueOf(this.debugLogging));
        root.add("debugLogging", (JsonElement)entry8);
        return root;
    }

    public void deserialize(JsonObject data) {
        this.predictiondidstanceoffset = data.get("predictiondidstanceoffset").getAsJsonObject().get("predictiondidstanceoffset").getAsInt();
        this.predictionarea = Math.max(2, Math.min(32, data.get("predictionarea").getAsJsonObject().get("predictionarea").getAsInt()));
        this.preGenArea = Math.max(1, Math.min(32, data.get("preGenArea").getAsJsonObject().get("preGenArea").getAsInt()));
        this.enablePrediction = data.get("enablePrediction").getAsJsonObject().get("enablePrediction").getAsBoolean();
        this.enableLazyChunkloading = data.get("enableLazyChunkloading").getAsJsonObject().get("enableLazyChunkloading").getAsBoolean();
        this.enableFasterChunkLoading = data.get("enableFasterChunkLoading").getAsJsonObject().get("enableFasterChunkLoading").getAsBoolean();
        this.enablePreGen = data.get("enablePreGen").getAsJsonObject().get("enablePreGen").getAsBoolean();
        this.lazyloadingspeed = Math.max(0.1, data.get("lazyloadingspeed").getAsJsonObject().get("lazyloadingspeed").getAsDouble());
        this.debugLogging = data.get("debugLogging").getAsJsonObject().get("debugLogging").getAsBoolean();
    }
}

