/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.event;

import com.betterchunkloading.BetterChunkLoading;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    public static Map<ChunkInfo, ShortList[]> delayedLoading = new ConcurrentHashMap<ChunkInfo, ShortList[]>();

    public static void printPlayerTickets(CommandSourceStack commandSourceStack) {
        for (ServerLevel level : commandSourceStack.m_81377_().m_129785_()) {
            level.m_7726_().f_8327_.m_140805_(level.m_7726_().f_8325_);
            int playerTickets = 0;
            for (Long2ObjectMap.Entry entry : level.m_7726_().f_8327_.f_140761_.long2ObjectEntrySet()) {
                for (Ticket ticket : (SortedArraySet)entry.getValue()) {
                    if (ticket == null || ticket.m_9428_() != TicketType.f_9444_) continue;
                    ++playerTickets;
                }
            }
            commandSourceStack.m_243053_((Component)Component.m_237113_((String)("Dimension:" + level.m_46472_().m_135782_().toString())));
            commandSourceStack.m_243053_((Component)Component.m_237113_((String)("Player tickets(viewdistance):" + playerTickets)));
            BetterChunkLoading.LOGGER.warn("Dimension:" + level.m_46472_().m_135782_().toString());
            BetterChunkLoading.LOGGER.warn("Player tickets(viewdistance):" + playerTickets);
            playerTickets = 0;
            for (Long2ObjectMap.Entry entry : level.m_7726_().f_8327_.f_183901_.f_184143_.long2ObjectEntrySet()) {
                for (Ticket ticket : (SortedArraySet)entry.getValue()) {
                    if (ticket == null || ticket.m_9428_() != TicketType.f_9444_) continue;
                    ++playerTickets;
                }
            }
            commandSourceStack.m_243053_((Component)Component.m_237113_((String)("Player ticking(sim distance) tickets:" + playerTickets)));
            BetterChunkLoading.LOGGER.warn("Player ticking(sim distance) tickets:" + playerTickets);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            BetterChunkLoading.player_modifier = (int)(1.0 + (double)event.getServer().m_7416_() * 0.3);
            if (event.getServer().m_7416_() == 0) {
                BetterChunkLoading.player_modifier = 0;
            }
            long serverTime = event.getServer().m_129921_();
            Iterator<Map.Entry<ChunkInfo, ShortList[]>> iterator = delayedLoading.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ChunkInfo, ShortList[]> dataEntry = iterator.next();
                if (serverTime - dataEntry.getKey().originalTime > 100L && dataEntry.getKey().level.m_7232_(dataEntry.getKey().pos.f_45578_, dataEntry.getKey().pos.f_45579_) && dataEntry.getKey().level.m_7232_(dataEntry.getKey().pos.f_45578_ + 1, dataEntry.getKey().pos.f_45579_) && dataEntry.getKey().level.m_7232_(dataEntry.getKey().pos.f_45578_, dataEntry.getKey().pos.f_45579_ + 1) && dataEntry.getKey().level.m_7232_(dataEntry.getKey().pos.f_45578_ - 1, dataEntry.getKey().pos.f_45579_) && dataEntry.getKey().level.m_7232_(dataEntry.getKey().pos.f_45578_ - 1, dataEntry.getKey().pos.f_45579_ - 1)) {
                    EventHandler.applyToChunk(dataEntry);
                    iterator.remove();
                }
                if (serverTime - dataEntry.getKey().originalTime <= 2400L) continue;
                iterator.remove();
                return;
            }
        }
    }

    private static void applyToChunk(Map.Entry<ChunkInfo, ShortList[]> dataEntry) {
        LevelChunk chunk = dataEntry.getKey().level.m_6325_(dataEntry.getKey().pos.f_45578_, dataEntry.getKey().pos.f_45579_);
        for (int i = 0; i < dataEntry.getValue().length; ++i) {
            if (dataEntry.getValue()[i] == null) continue;
            for (Short oshort : dataEntry.getValue()[i]) {
                BlockPos blockpos = ProtoChunk.m_63227_((short)oshort, (int)chunk.m_151568_(i), (ChunkPos)dataEntry.getKey().pos);
                BlockState blockstate = chunk.m_8055_(blockpos);
                FluidState fluidstate = blockstate.m_60819_();
                if (!fluidstate.m_76178_()) {
                    fluidstate.m_76163_(dataEntry.getKey().level, blockpos);
                }
                if (blockstate.m_60734_() instanceof LiquidBlock) continue;
                BlockState blockstate1 = Block.m_49931_((BlockState)blockstate, (LevelAccessor)dataEntry.getKey().level, (BlockPos)blockpos);
                dataEntry.getKey().level.m_7731_(blockpos, blockstate1, 20);
            }
            dataEntry.getValue()[i].clear();
        }
        ((ServerChunkCache)dataEntry.getKey().level.m_7726_()).m_8438_(BetterChunkLoading.TICKET_2min, dataEntry.getKey().pos, 1, (Object)dataEntry.getKey().pos);
    }

    public static class ChunkInfo {
        private final long originalTime;
        private final ChunkPos pos;
        private final Level level;

        public ChunkInfo(long originalTime, ChunkPos pos, Level level) {
            this.originalTime = originalTime;
            this.pos = pos;
            this.level = level;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkInfo chunkInfo = (ChunkInfo)o;
            return Objects.equals(this.pos, chunkInfo.pos);
        }

        public int hashCode() {
            return Objects.hash(this.pos);
        }
    }
}

