/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.blocks.natural.SkyLeavesBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;

public class FruitLeavesBlock
extends SkyLeavesBlock
implements BonemealableBlock {
    public static final EnumProperty<Growth> GROWTH = EnumProperty.m_61587_((String)"growth", Growth.class);
    private final Supplier<ItemLike> berry;

    public FruitLeavesBlock(BlockBehaviour.Properties props, Supplier<ItemLike> berry) {
        super(props);
        this.berry = berry;
        this.m_49959_((BlockState)this.m_49966_().m_61124_(GROWTH, (Comparable)((Object)Growth.CANT_GROW)));
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_54419_) == false || state.m_61143_(GROWTH) == Growth.CAN_GROW;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (this.ableToGrow(state) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (rand.m_188501_() < 0.1f ? 1 : 0) != 0)) {
            this.grow(state, level, pos);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
        super.m_213898_(state, level, pos, rand);
    }

    public boolean ableToGrow(BlockState state) {
        return state.m_61143_(GROWTH) == Growth.CAN_GROW;
    }

    public void grow(BlockState state, ServerLevel level, BlockPos pos) {
        level.m_46597_(pos, (BlockState)state.m_61124_(GROWTH, (Comparable)((Object)Growth.GROWN)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (state.m_61143_(GROWTH) == Growth.GROWN) {
            level.m_46597_(pos, (BlockState)state.m_61124_(GROWTH, (Comparable)((Object)Growth.CAN_GROW)));
            level.m_5594_(null, pos, SoundEvents.f_11990_, SoundSource.BLOCKS, 1.0f, 1.0f);
            FruitLeavesBlock.m_152435_((Level)level, (BlockPos)pos, (Direction)hit.m_82434_(), (ItemStack)new ItemStack(this.berry.get()));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{GROWTH});
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return this.ableToGrow(state);
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return rand.m_188501_() < 0.75f;
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        this.grow(state, level, pos);
    }

    public static enum Growth implements StringRepresentable
    {
        CANT_GROW("cant_grow"),
        CAN_GROW("can_grow"),
        GROWN("grown");

        private final String name;

        private Growth(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

