/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.screen.widgets;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.client.SkiesClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class InventoryTabButton
extends Button {
    private static final ResourceLocation TEXTURE = BlueSkies.locate("textures/gui/inventory_tabs.png");
    private final int textureIndex;
    private final int posIndex;
    private final boolean enabled;
    private final Screen parentGui;
    private final SoundEvent openSound;
    private long hoverStart = 0L;
    private int offsetY = 0;
    private boolean wasHovered = false;
    private boolean isRecipeOpen = false;

    public InventoryTabButton(int textureIndex, Screen parentGui, boolean enabled, int heightIndex, Button.OnPress onPress) {
        this(textureIndex, parentGui, enabled, heightIndex, onPress, SoundEvents.f_12490_);
    }

    public InventoryTabButton(int textureIndex, Screen parentGui, boolean enabled, int posIndex, Button.OnPress onPress, SoundEvent openSound) {
        super(parentGui.f_96543_ / 2 + InventoryTabButton.xPosFromIndex(posIndex), parentGui.f_96544_ / 2 + 83, 22, 22, (Component)Component.m_237119_(), onPress);
        this.textureIndex = textureIndex;
        this.posIndex = posIndex;
        this.enabled = enabled;
        this.parentGui = parentGui;
        this.openSound = openSound;
    }

    private static int xPosFromIndex(int heightIndex) {
        if (BlueSkiesConfig.CLIENT.leftAlignInventoryTabs()) {
            return -63 + (heightIndex - 1) * 22;
        }
        return 86 + (-heightIndex - 1) * 22;
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            boolean wasRecipeOpen = this.isRecipeOpen;
            boolean bl = this.isRecipeOpen = this.parentGui.getClass() == InventoryScreen.class && ((InventoryScreen)this.parentGui).m_5564_().m_100385_();
            if (wasRecipeOpen != this.isRecipeOpen) {
                this.f_93620_ = this.isRecipeOpen ? this.f_93620_ + 77 : this.f_93620_ - 77;
            }
        } else if (this.parentGui instanceof CreativeModeInventoryScreen) {
            this.f_93624_ = ((CreativeModeInventoryScreen)this.parentGui).m_98628_() == 11;
        }
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
    }

    public void m_6303_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        SkiesClientUtil.bind(TEXTURE);
        long time = Util.m_137550_();
        int animationTime = 180;
        int texStartX = 22 * this.textureIndex;
        int height = 18;
        if (this.enabled) {
            if (this.m_198029_()) {
                if (!this.wasHovered) {
                    this.hoverStart = Util.m_137550_();
                }
                if (this.offsetY < height) {
                    this.offsetY = (int)((time - this.hoverStart) * (long)height / (long)animationTime);
                }
                if (this.offsetY > height) {
                    this.offsetY = height;
                }
            } else {
                if (this.wasHovered) {
                    this.hoverStart = Util.m_137550_();
                }
                if (this.offsetY > 0) {
                    this.offsetY = height - (int)((time - this.hoverStart) * (long)height / (long)animationTime);
                }
                if (this.offsetY < 0) {
                    this.offsetY = 0;
                }
            }
        } else {
            this.hoverStart = 0L;
            this.offsetY = height;
        }
        this.wasHovered = this.m_198029_();
        InventoryTabButton.m_93133_((PoseStack)matrix, (int)this.f_93620_, (int)this.f_93621_, (float)texStartX, (float)(height - this.offsetY + (this.enabled ? height + 4 : 0)), (int)(height + 4), (int)(4 + this.offsetY), (int)128, (int)128);
        if (this.textureIndex == 3) {
            SkiesPlayer.ifPresent(Minecraft.m_91087_().f_91074_, skyPlayer -> {
                if (!skyPlayer.hasOpenedBlueLore()) {
                    SkiesClientUtil.renderExclamation(matrix, this.f_93620_ + 7, this.f_93621_ + 9 + this.offsetY);
                }
            });
        }
    }

    public void m_5691_() {
        if (this.enabled) {
            this.f_93717_.m_93750_((Button)this);
        }
    }

    public boolean m_5755_(boolean forward) {
        return !this.enabled ? false : super.m_5755_(forward);
    }

    public void m_7435_(SoundManager soundHandler) {
        soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)this.openSound, (float)1.0f));
    }
}

