/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.data.providers.SkiesBiomeProv;
import com.legacy.blue_skies.world.everbright.biome.provider.EverbrightBiomeSource;
import com.legacy.blue_skies.world.everdawn.biome.provider.EverdawnBiomeSource;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.RegisterEvent;

public class SkiesBiomes {
    public static final RegistrarHandler<Biome> REG = RegistrarHandler.getOrCreate((ResourceKey)Registry.f_122885_, (String)"blue_skies");
    public static final Registrar.Pointer<Biome> CALMING_SKIES = SkiesBiomes.create("calming_skies", SkiesBiomeProv.Makers::calmingSkies);
    public static final Registrar.Pointer<Biome> BRIGHTLANDS = SkiesBiomes.create("brightlands", SkiesBiomeProv.Makers::brightlands);
    public static final Registrar.Pointer<Biome> SLUSHLANDS = SkiesBiomes.create("slushlands", SkiesBiomeProv.Makers::slushlands);
    public static final Registrar.Pointer<Biome> FROSTBITTEN_FOREST = SkiesBiomes.create("frostbitten_forest", () -> SkiesBiomeProv.Makers.frostbittenForest(false));
    public static final Registrar.Pointer<Biome> FROSTBITTEN_FOREST_CLEARING = SkiesBiomes.create("frostbitten_forest_clearing", () -> SkiesBiomeProv.Makers.frostbittenForest(true));
    public static final Registrar.Pointer<Biome> PEEKING_OCEAN = SkiesBiomes.create("peeking_ocean", () -> SkiesBiomeProv.Makers.peekingOcean(false, false));
    public static final Registrar.Pointer<Biome> DEEP_PEEKING_OCEAN = SkiesBiomes.create("deep_peeking_ocean", () -> SkiesBiomeProv.Makers.peekingOcean(true, false));
    public static final Registrar.Pointer<Biome> BRUMBLE_FOREST = SkiesBiomes.create("brumble_forest", () -> SkiesBiomeProv.Makers.peekingOcean(true, true));
    public static final Registrar.Pointer<Biome> MIDDAY_SHORE = SkiesBiomes.create("midday_shore", SkiesBiomeProv.Makers::middayShore);
    public static final Registrar.Pointer<Biome> SNOW_COVERED_PINES = SkiesBiomes.create("snow_covered_pines", SkiesBiomeProv.Makers::snowCoveredPines);
    public static final Registrar.Pointer<Biome> BRISK_MEADOW = SkiesBiomes.create("brisk_meadow", SkiesBiomeProv.Makers::briskMeadow);
    public static final Registrar.Pointer<Biome> POLAR_HIGHLAND = SkiesBiomes.create("polar_highland", SkiesBiomeProv.Makers::polarHighland);
    public static final Registrar.Pointer<Biome> UNORTHODOX_VALLEY = SkiesBiomes.create("unorthodox_valley", SkiesBiomeProv.Makers::unorthodoxValley);
    public static final Registrar.Pointer<Biome> SHADED_WOODLANDS = SkiesBiomes.create("shaded_woodlands", SkiesBiomeProv.Makers::shadedWoodlands);
    public static final Registrar.Pointer<Biome> CRYSTAL_DUNES = SkiesBiomes.create("crystal_dunes", () -> SkiesBiomeProv.Makers.crystalDunes(false));
    public static final Registrar.Pointer<Biome> CRYSTAL_DUNES_SPIKES = SkiesBiomes.create("crystal_dunes_spikes", () -> SkiesBiomeProv.Makers.crystalDunes(true));
    public static final Registrar.Pointer<Biome> SUNSET_MAPLE_FOREST = SkiesBiomes.create("sunset_maple_forest", SkiesBiomeProv.Makers::sunsetMapleForest);
    public static final Registrar.Pointer<Biome> RISING_CREEK = SkiesBiomes.create("rising_creek", SkiesBiomeProv.Makers::risingCreek);
    public static final Registrar.Pointer<Biome> MOONLIT_RESERVOIR = SkiesBiomes.create("moonlit_reservoir", SkiesBiomeProv.Makers::moonlitReservoir);
    public static final Registrar.Pointer<Biome> CRYSTAL_ROUGHS = SkiesBiomes.create("crystal_roughs", SkiesBiomeProv.Makers::crystalRoughs);
    public static final Registrar.Pointer<Biome> SEARING_GRASSLAND = SkiesBiomes.create("searing_grassland", SkiesBiomeProv.Makers::searingGrassland);
    public static final Registrar.Pointer<Biome> CRESCENT_ORCHARD = SkiesBiomes.create("crescent_orchard", () -> SkiesBiomeProv.Makers.crescentOrchard(false));
    public static final Registrar.Pointer<Biome> CRESCENT_ORCHARD_LAKE = SkiesBiomes.create("crescent_orchard_lake", () -> SkiesBiomeProv.Makers.crescentOrchard(true));
    public static final List<Registrar.Pointer<Biome>> EVERBRIGHT_BIOMES = Lists.newArrayList();
    public static final List<Registrar.Pointer<Biome>> EVERDAWN_BIOMES = Lists.newArrayList();

    public static void init(RegisterEvent event) {
        SkiesBiomes.register(event, Arrays.asList(CALMING_SKIES, BRIGHTLANDS, SLUSHLANDS, FROSTBITTEN_FOREST, PEEKING_OCEAN, MIDDAY_SHORE), true);
        SkiesBiomes.register(event, Arrays.asList(UNORTHODOX_VALLEY, SHADED_WOODLANDS, CRYSTAL_DUNES, SUNSET_MAPLE_FOREST, RISING_CREEK), false);
        SkiesBiomes.register(event, Arrays.asList(SNOW_COVERED_PINES, DEEP_PEEKING_OCEAN, BRISK_MEADOW, POLAR_HIGHLAND, FROSTBITTEN_FOREST_CLEARING, BRUMBLE_FOREST), true);
        SkiesBiomes.register(event, Arrays.asList(MOONLIT_RESERVOIR, CRYSTAL_ROUGHS, SEARING_GRASSLAND, CRESCENT_ORCHARD, CRESCENT_ORCHARD_LAKE, CRYSTAL_DUNES_SPIKES), false);
        Registry.m_122961_((Registry)Registry.f_122889_, (String)"everbright", EverbrightBiomeSource.CODEC);
        Registry.m_122961_((Registry)Registry.f_122889_, (String)"everdawn", EverdawnBiomeSource.CODEC);
    }

    public static void register(RegisterEvent event, List<Registrar.Pointer<Biome>> biome, boolean inEverbright) {
        biome.forEach(b -> {
            b.register(event);
            b.getKey();
            if (inEverbright) {
                EVERBRIGHT_BIOMES.add((Registrar.Pointer<Biome>)b);
            } else {
                EVERDAWN_BIOMES.add((Registrar.Pointer<Biome>)b);
            }
        });
    }

    private static Registrar.Pointer<Biome> create(String name, Supplier<Biome> biome) {
        return REG.createPointer(name, biome);
    }

    public static class SurfaceBuilders {
    }
}

