/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.crafting.ToolRecipe;
import com.legacy.blue_skies.crafting.ToolRecipeSerializer;
import com.legacy.blue_skies.util.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

public class SkiesRecipes {
    public static final Map<ResourceLocation, RecipeSerializer<?>> SERIALIZERS = new HashMap();
    public static final String[] TOOL_TYPES = new String[]{"pickaxe", "axe", "shovel", "hoe", "sword"};

    public static void init(RegisterEvent event) {
        Arrays.asList(ToolRecipe.Materials.values()).forEach(material -> {
            for (int t = 0; t < TOOL_TYPES.length; ++t) {
                ResourceLocation toolName = BlueSkies.locate(StringUtil.toLower(material.name()) + "_" + TOOL_TYPES[t]);
                Item tool = (Item)ForgeRegistries.ITEMS.getValue(toolName);
                if (tool == null) {
                    throw new NullPointerException(String.format("The item id \"%s\" does not exist. Could not create a recipe for it.", toolName.toString()));
                }
                ToolRecipeSerializer<ToolRecipe> serializer = new ToolRecipeSerializer<ToolRecipe>(ToolRecipe::new, (ToolRecipe.Materials)((Object)material), tool, ToolRecipe.RecipeShapes.fromString(TOOL_TYPES[t]));
                event.register(Registry.f_122915_, toolName, () -> serializer);
                SERIALIZERS.put(toolName, serializer);
            }
        });
    }
}

