/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid.impl;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidSnapshot;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.IntToLongFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.Fluids;

public class SimpleFluidContainer
implements FluidContainer {
    public static final String FLUID_KEY = "StoredFluids";
    public NonNullList<FluidHolder> storedFluid;
    public final IntToLongFunction maxAmount;
    public final BiPredicate<Integer, FluidHolder> fluidFilter;

    public SimpleFluidContainer(IntToLongFunction maxAmount, int tanks, BiPredicate<Integer, FluidHolder> fluidFilter) {
        this.maxAmount = maxAmount;
        this.fluidFilter = fluidFilter;
        this.storedFluid = NonNullList.m_122780_((int)tanks, (Object)FluidHolder.empty());
    }

    public SimpleFluidContainer(long maxAmount, int tanks, BiPredicate<Integer, FluidHolder> fluidFilter) {
        this(integer -> maxAmount, tanks, fluidFilter);
    }

    @Override
    public long insertFluid(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            if (((FluidHolder)this.storedFluid.get(i)).isEmpty()) {
                FluidHolder insertedFluid = fluid.copyHolder();
                insertedFluid.setAmount(Mth.m_14053_((long)fluid.getFluidAmount(), (long)0L, (long)this.maxAmount.applyAsLong(i)));
                if (simulate) {
                    return insertedFluid.getFluidAmount();
                }
                this.storedFluid.set(i, (Object)insertedFluid);
                return ((FluidHolder)this.storedFluid.get(i)).getFluidAmount();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long insertedAmount = Mth.m_14053_((long)fluid.getFluidAmount(), (long)0L, (long)(this.maxAmount.applyAsLong(i) - ((FluidHolder)this.storedFluid.get(i)).getFluidAmount()));
            if (simulate) {
                return insertedAmount;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() + insertedAmount);
            return insertedAmount;
        }
        return 0L;
    }

    @Override
    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            FluidHolder toExtract = fluid.copyHolder();
            if (this.storedFluid.isEmpty()) {
                return FluidHolder.empty();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long extractedAmount = Mth.m_14053_((long)fluid.getFluidAmount(), (long)0L, (long)((FluidHolder)this.storedFluid.get(i)).getFluidAmount());
            toExtract.setAmount(extractedAmount);
            if (simulate) {
                return toExtract;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() - extractedAmount);
            if (((FluidHolder)this.storedFluid.get(i)).getFluidAmount() == 0L) {
                this.storedFluid.set(i, (Object)FluidHolder.empty());
            }
            return toExtract;
        }
        return FluidHolder.empty();
    }

    @Override
    public long internalInsert(FluidHolder fluid, boolean simulate) {
        return this.insertFluid(fluid, simulate);
    }

    @Override
    public FluidHolder internalExtract(FluidHolder fluid, boolean simulate) {
        return this.extractFluid(fluid, simulate);
    }

    @Override
    public long extractFromSlot(FluidHolder fluidHolder, FluidHolder toInsert, Runnable snapshot) {
        if (Objects.equals(fluidHolder.getCompound(), toInsert.getCompound()) && fluidHolder.getFluid().m_6212_(toInsert.getFluid())) {
            long extracted = Mth.m_14053_((long)toInsert.getFluidAmount(), (long)0L, (long)fluidHolder.getFluidAmount());
            snapshot.run();
            fluidHolder.setAmount(fluidHolder.getFluidAmount() - extracted);
            if (fluidHolder.getFluidAmount() == 0L) {
                fluidHolder.setFluid(Fluids.f_76191_);
            }
            return extracted;
        }
        return 0L;
    }

    @Override
    public void setFluid(int slot, FluidHolder fluid) {
        this.storedFluid.set(slot, (Object)fluid);
    }

    @Override
    public List<FluidHolder> getFluids() {
        return this.storedFluid;
    }

    @Override
    public int getSize() {
        return this.getFluids().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getFluids().isEmpty() || this.getFluids().get(0) == null || this.getFluids().get(0).isEmpty();
    }

    @Override
    public SimpleFluidContainer copy() {
        return new SimpleFluidContainer(this.maxAmount, this.getSize(), this.fluidFilter);
    }

    @Override
    public long getTankCapacity(int slot) {
        return this.maxAmount.applyAsLong(slot);
    }

    @Override
    public void fromContainer(FluidContainer container) {
        this.storedFluid = NonNullList.m_122780_((int)container.getSize(), (Object)FluidHolder.empty());
        for (int i = 0; i < container.getSize(); ++i) {
            this.storedFluid.set(i, (Object)container.getFluids().get(i).copyHolder());
        }
    }

    @Override
    public void deserialize(CompoundTag root) {
        CompoundTag tag = root.m_128469_("BotariumData");
        ListTag fluids = tag.m_128437_(FLUID_KEY, 10);
        for (int i = 0; i < fluids.size(); ++i) {
            CompoundTag fluid = fluids.m_128728_(i);
            this.storedFluid.set(i, (Object)FluidHolder.fromCompound(fluid));
        }
    }

    @Override
    public CompoundTag serialize(CompoundTag root) {
        CompoundTag tag = root.m_128469_("BotariumData");
        if (!this.storedFluid.isEmpty()) {
            ListTag tags = new ListTag();
            for (FluidHolder fluidHolder : this.storedFluid) {
                tags.add((Object)fluidHolder.serialize());
            }
            tag.m_128365_(FLUID_KEY, (Tag)tags);
        } else {
            tag.m_128365_(FLUID_KEY, (Tag)new ListTag());
        }
        root.m_128365_("BotariumData", (Tag)tag);
        return root;
    }

    @Override
    public boolean allowsInsertion() {
        return true;
    }

    @Override
    public boolean allowsExtraction() {
        return true;
    }

    @Override
    public boolean isFluidValid(int slot, FluidHolder fluidHolder) {
        return this.fluidFilter.test(slot, fluidHolder);
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return new SimpleFluidSnapshot(this);
    }

    public void m_6211_() {
        this.storedFluid.clear();
    }
}

