/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen.widgets;

import com.direwolf20.buildinggadgets.client.OurSounds;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class GuiIconActionable
extends Button {
    private Predicate<Boolean> action;
    private boolean selected;
    private boolean isSelectable;
    private Color selectedColor = new Color(0, 255, 0, 50);
    private Color deselectedColor;
    private Color activeColor = this.deselectedColor = new Color(255, 255, 255, 50);
    private ResourceLocation selectedTexture;
    private ResourceLocation deselectedTexture;

    public GuiIconActionable(int x, int y, String texture, Component message, boolean isSelectable, Predicate<Boolean> action) {
        super(x, y, 25, 25, message, b -> {});
        this.isSelectable = isSelectable;
        this.action = action;
        this.setSelected(action.test(false));
        String assetLocation = "textures/gui/setting/%s.png";
        this.deselectedTexture = new ResourceLocation("buildinggadgets", String.format(assetLocation, texture));
        this.selectedTexture = !isSelectable ? this.deselectedTexture : new ResourceLocation("buildinggadgets", String.format(assetLocation, texture + "_selected"));
    }

    public GuiIconActionable(int x, int y, String texture, Component message, Predicate<Boolean> action) {
        this(x, y, texture, message, false, action);
    }

    public void setFaded(boolean faded) {
        this.f_93625_ = faded ? 0.6f : 1.0f;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.activeColor = selected ? this.selectedColor : this.deselectedColor;
    }

    public void m_7435_(SoundManager soundHandler) {
        soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)OurSounds.BEEP.get()), (float)(this.selected ? 0.6f : 1.0f)));
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
        this.action.test(true);
        if (!this.isSelectable) {
            return;
        }
        this.setSelected(!this.selected);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTick) {
        if (!this.f_93624_) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GuiIconActionable.m_93172_((PoseStack)matrices, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)this.activeColor.getRGB());
        RenderSystem.m_157456_((int)0, (ResourceLocation)(this.selected ? this.selectedTexture : this.deselectedTexture));
        RenderSystem.m_157429_((float)((float)this.activeColor.getRed() / 255.0f), (float)((float)this.activeColor.getGreen() / 255.0f), (float)((float)this.activeColor.getBlue() / 255.0f), (float)this.f_93625_);
        GuiIconActionable.m_93133_((PoseStack)matrices, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)0.0f, (int)this.f_93618_, (int)this.f_93619_, (int)this.f_93618_, (int)this.f_93619_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        if (mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_) {
            GuiIconActionable.m_93236_((PoseStack)matrices, (Font)Minecraft.m_91087_().f_91062_, (String)this.m_6035_().getString(), (int)(mouseX > Minecraft.m_91087_().m_91268_().m_85445_() / 2 ? mouseX + 2 : mouseX - Minecraft.m_91087_().f_91062_.m_92895_(this.m_6035_().getString())), (int)(mouseY - 10), (int)(this.activeColor.getRGB() | 0xFF000000));
        }
    }
}

