/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.capability;

import com.direwolf20.buildinggadgets.common.items.ConstructionPasteContainer;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import javax.annotation.Nonnull;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandlerModifiable;

public final class PasteContainerItemHandler
implements IItemHandlerModifiable {
    private final ItemStack container;
    private final boolean isCreative;

    public PasteContainerItemHandler(ItemStack container) {
        this.container = container;
        this.isCreative = this.getContainerItem().isCreative();
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.setCount(stack.m_41613_(), false);
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int count = this.getCount();
        return count <= 0 ? ItemStack.f_41583_ : new ItemStack((ItemLike)OurItems.CONSTRUCTION_PASTE_ITEM.get(), count);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.m_41619_() || !this.isItemValid(slot, stack)) {
            return stack;
        }
        if (this.isCreative) {
            return ItemStack.f_41583_;
        }
        int currentCount = this.getCount();
        int newCount = this.setCount(currentCount + stack.m_41613_(), simulate);
        int dif = newCount - currentCount;
        if (dif == 0) {
            return stack;
        }
        stack = stack.m_41777_();
        stack.m_41764_(stack.m_41613_() - dif);
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int newCount;
        if (amount <= 0) {
            return ItemStack.f_41583_;
        }
        if (this.isCreative) {
            return new ItemStack((ItemLike)OurItems.CONSTRUCTION_PASTE_ITEM.get(), amount);
        }
        int currentCount = this.getCount();
        int dif = currentCount - (newCount = this.setCount(currentCount - amount, simulate));
        if (dif == 0) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)OurItems.CONSTRUCTION_PASTE_ITEM.get(), dif);
    }

    public int getSlotLimit(int slot) {
        return this.getContainerItem().getMaxCapacity();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.m_41720_() == OurItems.CONSTRUCTION_PASTE_ITEM.get();
    }

    private int getCount() {
        return this.getContainerItem().getPasteCount(this.container);
    }

    private ConstructionPasteContainer getContainerItem() {
        return (ConstructionPasteContainer)this.container.m_41720_();
    }

    private int setCount(int count, boolean simulate) {
        int res = Mth.m_14045_((int)count, (int)0, (int)this.getContainerItem().getMaxCapacity());
        if (!simulate) {
            this.getContainerItem().setPasteCount(this.container, res);
        }
        return res;
    }
}

