/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.modes;

import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.items.modes.XYZ;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;

public class VerticalColumnMode
extends AbstractMode {
    public VerticalColumnMode(boolean isExchanging) {
        super(isExchanging);
    }

    @Override
    List<BlockPos> collect(AbstractMode.UseContext context, Player player, BlockPos start) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        int halfRange = context.getRange() / 2;
        if (XYZ.isAxisY(context.getHitSide())) {
            if (this.isExchanging()) {
                Direction playerFacing = player.m_6350_();
                for (int i = -halfRange; i <= halfRange; ++i) {
                    coordinates.add(XYZ.extendPosSingle(i, start, playerFacing, XYZ.fromFacing(playerFacing)));
                }
            } else {
                for (int i = 0; i < context.getRange(); ++i) {
                    coordinates.add(XYZ.extendPosSingle(i, start, context.getHitSide(), XYZ.Y));
                }
            }
        } else {
            for (int i = -halfRange; i <= halfRange; ++i) {
                coordinates.add(XYZ.extendPosSingle(i, start, context.getHitSide(), XYZ.Y));
            }
        }
        return coordinates;
    }

    @Override
    public BlockPos withOffset(AbstractMode.UseContext context) {
        return XYZ.isAxisY(context.getHitSide()) ? super.withOffset(context) : context.getStartPos();
    }
}

