/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building.tilesupport;

import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataFactory;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataProvider;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.registry.Registries;
import com.direwolf20.buildinggadgets.common.tainted.template.SerialisationSupport;
import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public final class TileSupport {
    private static ITileDataFactory DATA_PROVIDER_FACTORY = new DataProviderFactory();
    private static final ITileEntityData DUMMY_TILE_ENTITY_DATA = new ITileEntityData(){

        @Override
        public ITileDataSerializer getSerializer() {
            return SerialisationSupport.dummyDataSerializer();
        }

        @Override
        public boolean placeIn(BuildContext context, BlockState state, BlockPos position) {
            return context.getWorld().m_7731_(position, state, 0);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    };

    private TileSupport() {
    }

    public static ITileDataFactory dataProviderFactory() {
        return DATA_PROVIDER_FACTORY;
    }

    public static ITileEntityData createTileData(@Nullable BlockEntity te) {
        if (te == null) {
            return TileSupport.dummyTileEntityData();
        }
        Iterator<ITileDataFactory> it = Registries.TileEntityData.getTileDataFactories().iterator();
        while (it.hasNext()) {
            ITileDataFactory factory = it.next();
            ITileEntityData res = factory.createDataFor(te);
            if (res == null) continue;
            return res;
        }
        return TileSupport.dummyTileEntityData();
    }

    public static ITileEntityData createTileData(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        return TileSupport.createTileData(te);
    }

    public static BlockData createBlockData(BlockState state, @Nullable BlockEntity te) {
        return new BlockData(Objects.requireNonNull(state), TileSupport.createTileData(te));
    }

    public static BlockData createBlockData(BlockGetter world, BlockPos pos) {
        return new BlockData(world.m_8055_(pos), TileSupport.createTileData(world, pos));
    }

    public static ITileEntityData dummyTileEntityData() {
        return DUMMY_TILE_ENTITY_DATA;
    }

    private static class DataProviderFactory
    implements ITileDataFactory {
        private DataProviderFactory() {
        }

        @Override
        @Nullable
        public ITileEntityData createDataFor(BlockEntity tileEntity) {
            if (tileEntity instanceof ITileDataProvider) {
                return ((ITileDataProvider)tileEntity).createTileData();
            }
            return null;
        }
    }
}

