/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory;

import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.ConstructionPaste;
import com.direwolf20.buildinggadgets.common.items.ConstructionPasteContainer;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.inventory.CreativeItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.HandlerInsertProvider;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IInsertProvider;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryLinker;
import com.direwolf20.buildinggadgets.common.tainted.inventory.PlayerInventoryInsertProvider;
import com.direwolf20.buildinggadgets.common.tainted.inventory.PlayerItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.handle.IObjectHandle;
import com.direwolf20.buildinggadgets.common.tainted.inventory.handle.ItemHandlerProvider;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.UniqueItem;
import com.direwolf20.buildinggadgets.common.tainted.registry.TopologicalRegistryBuilder;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.CommonUtils;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class InventoryHelper {
    public static final MaterialList PASTE_LIST = MaterialList.of(new UniqueItem((Item)OurItems.CONSTRUCTION_PASTE_ITEM.get()));
    private static final Set<Property<?>> UNSAFE_PROPERTIES = ImmutableSet.builder().add((Object)BlockStateProperties.f_61370_).add((Object)BlockStateProperties.f_61369_).add((Object)BlockStateProperties.f_61371_).add((Object)BlockStateProperties.f_61368_).add((Object)BlockStateProperties.f_61366_).add((Object)BlockStateProperties.f_61367_).build();
    private static final Set<Property<?>> BASE_UNSAFE_PROPERTIES = ImmutableSet.builder().add((Object)CropBlock.f_52244_).add((Object)DoublePlantBlock.f_52858_).add((Object)BlockStateProperties.f_61362_).build();
    public static final CreativeItemIndex CREATIVE_INDEX = new CreativeItemIndex();

    public static IItemIndex index(ItemStack tool, Player player) {
        if (player.m_7500_()) {
            return CREATIVE_INDEX;
        }
        return new PlayerItemIndex(tool, player);
    }

    static List<IInsertProvider> indexInsertProviders(ItemStack tool, Player player) {
        ImmutableList.Builder builder = ImmutableList.builder();
        InventoryLinker.getLinkedInventory(player.f_19853_, tool).ifPresent(e -> builder.add((Object)new HandlerInsertProvider((IItemHandler)e)));
        builder.add((Object)new PlayerInventoryInsertProvider(player));
        return builder.build();
    }

    static Map<Class<?>, Map<Object, List<IObjectHandle<?>>>> indexMap(ItemStack tool, Player player) {
        HashMap map = new HashMap();
        for (IItemHandler handler : InventoryHelper.getHandlers(tool, player)) {
            if (handler == null || handler.getSlots() <= 0) continue;
            ItemHandlerProvider.index(handler, map);
        }
        return map;
    }

    static List<IItemHandler> getHandlers(ItemStack stack, Player player) {
        ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
        InventoryLinker.getLinkedInventory(player.f_19853_, stack).ifPresent(handlers::add);
        player.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handlers::add);
        return handlers;
    }

    public static void registerHandleProviders() {
        InterModComms.sendTo((String)"buildinggadgets", (String)"imc_handle_provider", () -> () -> TopologicalRegistryBuilder.create().addMarker(Reference.MARKER_AFTER_RL).addValue(Reference.HandleProviderReference.STACK_HANDLER_ITEM_HANDLE_RL, new ItemHandlerProvider()).addDependency(Reference.HandleProviderReference.STACK_HANDLER_ITEM_HANDLE_RL, Reference.MARKER_AFTER_RL));
    }

    public static boolean giveItem(ItemStack itemStack, Player player, Level world) {
        List<IItemHandler> invContainers;
        ItemStack giveItemStack;
        if (player.m_7500_()) {
            return true;
        }
        if (itemStack.m_41720_() instanceof ConstructionPaste) {
            itemStack = InventoryHelper.addPasteToContainer(player, itemStack);
        }
        if (itemStack.m_41613_() == 0) {
            return true;
        }
        Inventory inv = player.m_150109_();
        List<Integer> slots = InventoryHelper.findItem(itemStack.m_41720_(), inv);
        for (int slot : slots) {
            boolean success;
            ItemStack stackInSlot = inv.m_8020_(slot);
            if (stackInSlot.m_41613_() >= stackInSlot.m_41720_().getMaxStackSize(stackInSlot) || !(success = inv.m_36054_(giveItemStack = itemStack.m_41777_()))) continue;
            return true;
        }
        ItemStack tool = AbstractGadget.getGadget(player);
        IItemHandler remoteInventory = (IItemHandler)InventoryLinker.getLinkedInventory(world, tool).orElse((Object)new EmptyHandler());
        if (remoteInventory.getSlots() > 0) {
            for (int i = 0; i < remoteInventory.getSlots(); ++i) {
                ItemStack containerItem = remoteInventory.getStackInSlot(i);
                ItemStack giveItemStack2 = itemStack.m_41777_();
                if (containerItem.m_41720_() != itemStack.m_41720_() && !containerItem.m_41619_()) continue;
                if ((giveItemStack2 = remoteInventory.insertItem(i, giveItemStack2, false)).m_41619_()) {
                    return true;
                }
                itemStack = giveItemStack2.m_41777_();
            }
        }
        if ((invContainers = InventoryHelper.findInvContainers(inv)).size() > 0) {
            for (IItemHandler container : invContainers) {
                for (int i = 0; i < container.getSlots(); ++i) {
                    ItemStack containerItem = container.getStackInSlot(i);
                    ItemStack giveItemStack3 = itemStack.m_41777_();
                    if (containerItem.m_41720_() != giveItemStack3.m_41720_()) continue;
                    if ((giveItemStack3 = container.insertItem(i, giveItemStack3, false)).m_41619_()) {
                        return true;
                    }
                    itemStack = giveItemStack3.m_41777_();
                }
            }
        }
        giveItemStack = itemStack.m_41777_();
        return inv.m_36054_(giveItemStack);
    }

    public static ItemStack addPasteToContainer(Player player, ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof ConstructionPaste)) {
            return itemStack;
        }
        Inventory inv = player.m_150109_();
        List<Integer> slots = InventoryHelper.findItemClass(ConstructionPasteContainer.class, inv);
        if (slots.size() == 0) {
            return itemStack;
        }
        HashMap<Integer, Integer> slotMap = new HashMap<Integer, Integer>();
        for (int slot : slots) {
            slotMap.put(slot, ConstructionPasteContainer.getPasteAmount(inv.m_8020_(slot)));
        }
        ArrayList list = new ArrayList(slotMap.entrySet());
        Comparator comparator = Map.Entry.comparingByValue();
        comparator = comparator.reversed();
        list.sort(comparator);
        for (Map.Entry entry : list) {
            ItemStack containerStack = inv.m_8020_(((Integer)entry.getKey()).intValue());
            ConstructionPasteContainer item = (ConstructionPasteContainer)containerStack.m_41720_();
            int maxAmount = item.getMaxCapacity();
            int pasteInContainer = ConstructionPasteContainer.getPasteAmount(containerStack);
            int freeSpace = item.isCreative() ? Integer.MAX_VALUE : maxAmount - pasteInContainer;
            int stackSize = itemStack.m_41613_();
            int remainingPaste = stackSize - freeSpace;
            if (remainingPaste < 0) {
                remainingPaste = 0;
            }
            int usedPaste = Math.abs(stackSize - remainingPaste);
            itemStack.m_41764_(remainingPaste);
            ConstructionPasteContainer.setPasteAmount(containerStack, pasteInContainer + usedPaste);
        }
        return itemStack;
    }

    private static List<IItemHandler> findInvContainers(Inventory inv) {
        ArrayList<IItemHandler> containers = new ArrayList<IItemHandler>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.m_8020_(i);
            stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(containers::add);
        }
        return containers;
    }

    public static int countInContainer(IItemHandler container, Item item) {
        int count = 0;
        for (int i = 0; i < container.getSlots(); ++i) {
            ItemStack tempItem = container.getStackInSlot(i);
            if (tempItem.m_41720_() != item) continue;
            count += tempItem.m_41613_();
        }
        return count;
    }

    private static List<Integer> findItem(Item item, Inventory inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() != item) continue;
            slots.add(i);
        }
        return slots;
    }

    public static List<Integer> findItemClass(Class<?> c, Inventory inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !c.isInstance(stack.m_41720_())) continue;
            slots.add(i);
        }
        return slots;
    }

    public static ItemStack getSilkTouchDrop(BlockState state) {
        return new ItemStack((ItemLike)state.m_60734_());
    }

    public static Optional<BlockData> getSafeBlockData(Player player, BlockPos pos, InteractionHand hand) {
        BlockPlaceContext blockItemUseContext = new BlockPlaceContext(new UseOnContext(player, hand, CommonUtils.fakeRayTrace(player.m_20182_(), pos)));
        return InventoryHelper.getSafeBlockData(player, pos, blockItemUseContext);
    }

    public static Optional<BlockData> getSafeBlockData(Player player, BlockPos pos, BlockPlaceContext useContext) {
        BlockEntity te;
        Level world = player.f_19853_;
        Boolean isCopyPasteGadget = AbstractGadget.getGadget(player).m_41720_() instanceof GadgetCopyPaste;
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof LiquidBlock) {
            return Optional.empty();
        }
        if (state.m_60734_() == OurBlocks.CONSTRUCTION_BLOCK.get() && (te = world.m_7702_(pos)) instanceof ConstructionBlockTileEntity) {
            return Optional.of(((ConstructionBlockTileEntity)te).getConstructionBlockData());
        }
        if (state.m_60734_() instanceof DoorBlock && state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
            return Optional.empty();
        }
        BlockState placeState = state.m_60734_().m_49966_();
        for (Property prop : placeState.m_61147_()) {
            if (BASE_UNSAFE_PROPERTIES.contains(prop) || !isCopyPasteGadget.booleanValue() && UNSAFE_PROPERTIES.contains(prop)) continue;
            placeState = InventoryHelper.applyProperty(placeState, state, prop);
        }
        return Optional.of(new BlockData(placeState, TileSupport.createTileData((BlockGetter)world, pos)));
    }

    private static <T extends Comparable<T>> BlockState applyProperty(BlockState state, BlockState from, Property<T> prop) {
        return (BlockState)state.m_61124_(prop, from.m_61143_(prop));
    }
}

