/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory.materials;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObjectSerializer;
import com.direwolf20.buildinggadgets.common.tainted.registry.Registries;
import com.direwolf20.buildinggadgets.common.util.ref.NBTKeys;
import com.direwolf20.buildinggadgets.common.util.tools.RegistryUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.PeekingIterator;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

class SimpleMaterialListEntry
implements MaterialListEntry<SimpleMaterialListEntry> {
    static final MaterialListEntry.Serializer<SimpleMaterialListEntry> SERIALIZER = new Serializer();
    private final ImmutableMultiset<IUniqueObject<?>> items;

    SimpleMaterialListEntry(ImmutableMultiset<IUniqueObject<?>> items) {
        this.items = Objects.requireNonNull(items, "Cannot have a SimpleMaterialListEntry without any Materials!");
    }

    ImmutableMultiset<IUniqueObject<?>> getItems() {
        return this.items;
    }

    @Override
    public PeekingIterator<ImmutableMultiset<IUniqueObject<?>>> iterator() {
        return Iterators.peekingIterator((Iterator)Iterators.singletonIterator(this.items));
    }

    @Override
    public MaterialListEntry.Serializer<SimpleMaterialListEntry> getSerializer() {
        return SERIALIZER;
    }

    public SimpleMaterialListEntry simplify() {
        return this;
    }

    private static class Serializer
    implements MaterialListEntry.Serializer<SimpleMaterialListEntry> {
        private static final Comparator<Multiset.Entry<IUniqueObject<?>>> COMPARATOR = Comparator.comparing(e -> ((IUniqueObject)e.getElement()).getObjectRegistryName()).thenComparingInt(Multiset.Entry::getCount);

        private Serializer() {
        }

        @Override
        public SimpleMaterialListEntry readFromNBT(CompoundTag nbt, boolean persisted) {
            ListTag nbtList = nbt.m_128437_("data", 10);
            ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
            for (Tag nbtEntry : nbtList) {
                IUniqueObjectSerializer serializer;
                CompoundTag compoundEntry = (CompoundTag)nbtEntry;
                IUniqueObjectSerializer iUniqueObjectSerializer = serializer = persisted ? RegistryUtils.getFromString(Registries.UNIQUE_DATA_SERIALIZER_REGISTRY.get(), compoundEntry.m_128461_("serializer")) : RegistryUtils.getById(Registries.UNIQUE_DATA_SERIALIZER_REGISTRY.get(), compoundEntry.m_128451_("serializer"));
                if (serializer == null) {
                    BuildingGadgets.LOG.error("Found unknown UniqueItem serializer {}. Skipping!", (Object)compoundEntry.m_128461_("serializer"));
                    continue;
                }
                builder.addCopies(serializer.deserialize(compoundEntry.m_128469_("data")), compoundEntry.m_128451_("count"));
            }
            return new SimpleMaterialListEntry(builder.build());
        }

        @Override
        public CompoundTag writeToNBT(SimpleMaterialListEntry listEntry, boolean persisted) {
            CompoundTag res = new CompoundTag();
            ListTag nbtList = new ListTag();
            for (Multiset.Entry entry : listEntry.getItems().entrySet()) {
                CompoundTag nbtEntry = new CompoundTag();
                if (persisted) {
                    nbtEntry.m_128359_("serializer", Registries.UNIQUE_DATA_SERIALIZER_REGISTRY.get().getKey((Object)((IUniqueObject)entry.getElement()).getSerializer()).toString());
                } else {
                    nbtEntry.m_128405_("serializer", RegistryUtils.getId(Registries.UNIQUE_DATA_SERIALIZER_REGISTRY.get(), ((IUniqueObject)entry.getElement()).getSerializer()));
                }
                nbtEntry.m_128365_("data", (Tag)((IUniqueObject)entry.getElement()).getSerializer().serialize((IUniqueObject)entry.getElement(), persisted));
                nbtEntry.m_128405_("count", entry.getCount());
                nbtList.add((Object)nbtEntry);
            }
            res.m_128365_("data", (Tag)nbtList);
            return res;
        }

        @Override
        public JsonSerializer<SimpleMaterialListEntry> asJsonSerializer(boolean printName, boolean extended) {
            return (src, typeOfSrc, context) -> {
                ImmutableMultiset<IUniqueObject<?>> set = src.getItems();
                JsonArray jsonArray = new JsonArray();
                for (Multiset.Entry entry : ImmutableList.sortedCopyOf(COMPARATOR, (Iterable)set.entrySet())) {
                    JsonElement element = ((IUniqueObject)entry.getElement()).getSerializer().asJsonSerializer(printName, extended).serialize((Object)((IUniqueObject)entry.getElement()), ((IUniqueObject)entry.getElement()).getClass(), context);
                    JsonObject obj = new JsonObject();
                    obj.add("item_type", context.serialize((Object)Registries.UNIQUE_DATA_SERIALIZER_REGISTRY.get().getKey((Object)((IUniqueObject)entry.getElement()).getSerializer())));
                    obj.addProperty("count", (Number)entry.getCount());
                    obj.add("item", element);
                    jsonArray.add((JsonElement)obj);
                }
                return jsonArray;
            };
        }

        @Override
        public JsonDeserializer<SimpleMaterialListEntry> asJsonDeserializer() {
            return (json, typeOfT, context) -> {
                JsonArray array = json.getAsJsonArray();
                ImmutableMultiset.Builder items = ImmutableMultiset.builder();
                for (JsonElement element : array) {
                    JsonObject object = element.getAsJsonObject();
                    ResourceLocation id = (ResourceLocation)context.deserialize(object.get("item_type"), ResourceLocation.class);
                    IUniqueObjectSerializer serializer = (IUniqueObjectSerializer)Registries.UNIQUE_DATA_SERIALIZER_REGISTRY.get().getValue(id);
                    if (serializer == null) continue;
                    int count = object.getAsJsonPrimitive("count").getAsInt();
                    IUniqueObject item = (IUniqueObject)serializer.asJsonDeserializer().deserialize(object.get("item"), IUniqueObject.class, context);
                    items.addCopies((Object)item, count);
                }
                return new SimpleMaterialListEntry(items.build());
            };
        }

        @Override
        public ResourceLocation getRegistryName() {
            return NBTKeys.SIMPLE_SERIALIZER_ID;
        }
    }
}

