/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.init;

import com.refinedmods.refinedstorage.render.BakedModelOverrideRegistry;
import com.refinedmods.refinedstorage.render.model.baked.CableCoverBakedModel;
import com.ultramega.cabletiers.CableTier;
import com.ultramega.cabletiers.ContentType;
import com.ultramega.cabletiers.gui.TieredConstructorScreen;
import com.ultramega.cabletiers.gui.TieredDestructorScreen;
import com.ultramega.cabletiers.gui.TieredDiskManipulatorScreen;
import com.ultramega.cabletiers.gui.TieredExporterScreen;
import com.ultramega.cabletiers.gui.TieredImporterScreen;
import com.ultramega.cabletiers.gui.TieredRequesterScreen;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientEventHandler {
    private static final BakedModelOverrideRegistry BAKED_MODEL_OVERRIDE_REGISTRY = new BakedModelOverrideRegistry();

    public ClientEventHandler() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModelBake);
    }

    public void init(FMLClientSetupEvent event) {
        for (CableTier tier : CableTier.VALUES) {
            MenuScreens.m_96206_(ContentType.EXPORTER.getContainerType(tier), TieredExporterScreen::new);
            MenuScreens.m_96206_(ContentType.IMPORTER.getContainerType(tier), TieredImporterScreen::new);
            MenuScreens.m_96206_(ContentType.CONSTRUCTOR.getContainerType(tier), TieredConstructorScreen::new);
            MenuScreens.m_96206_(ContentType.DESTRUCTOR.getContainerType(tier), TieredDestructorScreen::new);
            MenuScreens.m_96206_(ContentType.DISK_MANIPULATOR.getContainerType(tier), TieredDiskManipulatorScreen::new);
            MenuScreens.m_96206_(ContentType.REQUESTER.getContainerType(tier), TieredRequesterScreen::new);
            BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("cabletiers", ContentType.EXPORTER.getName(tier)), (base, registry) -> new CableCoverBakedModel(base));
            BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("cabletiers", ContentType.IMPORTER.getName(tier)), (base, registry) -> new CableCoverBakedModel(base));
            BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("cabletiers", ContentType.CONSTRUCTOR.getName(tier)), (base, registry) -> new CableCoverBakedModel(base));
            BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("cabletiers", ContentType.DESTRUCTOR.getName(tier)), (base, registry) -> new CableCoverBakedModel(base));
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelEvent.BakingCompleted e) {
        for (ResourceLocation id : e.getModels().keySet()) {
            BakedModelOverrideRegistry.BakedModelOverrideFactory factory = BAKED_MODEL_OVERRIDE_REGISTRY.get(new ResourceLocation(id.m_135827_(), id.m_135815_()));
            if (factory == null) continue;
            e.getModels().put(id, factory.create((BakedModel)e.getModels().get(id), e.getModels()));
        }
    }
}

