/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.node;

import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.ultramega.cabletiers.CableTier;
import com.ultramega.cabletiers.ContentType;
import com.ultramega.cabletiers.blockentity.TieredRequesterBlockEntity;
import com.ultramega.cabletiers.config.CableConfig;
import com.ultramega.cabletiers.node.TieredNetworkNode;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TieredRequesterNetworkNode
extends TieredNetworkNode<TieredRequesterNetworkNode>
implements IType {
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilter";
    private static final String NBT_AMOUNT = "Amount";
    private static final String NBT_MISSING = "MissingItems";
    private BaseItemHandler itemFilter = new BaseItemHandler(9 * this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private FluidInventory fluidFilter = new FluidInventory(9 * this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private int type = 0;
    private int amount = 0;
    private int slot = 0;
    private boolean isMissingItems = false;
    private int attemptAmount = this.getTierMaxCraftAmount();
    private ICraftingTask craftingTask = null;

    public TieredRequesterNetworkNode(Level level, BlockPos pos, CableTier tier) {
        super(level, pos, ContentType.REQUESTER, tier);
    }

    public int getEnergyUsage() {
        if (this.getTier() == CableTier.ELITE) {
            return 10 * (Integer)CableConfig.ELITE_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.ULTRA) {
            return 10 * (Integer)CableConfig.ULTRA_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.CREATIVE) {
            return 10 * (Integer)CableConfig.CREATIVE_ENERGY_COST.get();
        }
        return 0;
    }

    public void update() {
        super.update();
        if (this.network == null) {
            return;
        }
        if (!this.canUpdate()) {
            return;
        }
        if (this.getTier() != CableTier.CREATIVE && this.ticks % 70 == 0) {
            return;
        }
        if (this.craftingTask == null || !this.network.getCraftingManager().getTasks().contains(this.craftingTask)) {
            int count;
            ItemStack current;
            ItemStack filter;
            if (this.type == 0) {
                while (this.slot < this.itemFilter.getSlots() && this.itemFilter.getStackInSlot(this.slot).m_41619_()) {
                    ++this.slot;
                }
                if (this.slot >= this.itemFilter.getSlots()) {
                    this.slot = 0;
                }
                if (!(filter = this.itemFilter.getStackInSlot(this.slot)).m_41619_()) {
                    current = this.network.extractItem(filter, this.amount, Action.SIMULATE);
                    if (current == null || current.m_41619_() || current.m_41613_() < this.amount) {
                        int n = count = current == null || current.m_41619_() ? this.amount : this.amount - current.m_41613_();
                        if (count > 0) {
                            this.craftingTask = this.network.getCraftingManager().request((Object)this, filter, Math.min(this.attemptAmount, count));
                            this.isMissingItems = true;
                        }
                    } else {
                        this.isMissingItems = false;
                    }
                }
                if (this.attemptAmount > this.amount) {
                    this.attemptAmount = this.amount;
                }
                if (this.slot == 0) {
                    this.attemptAmount = this.attemptAmount <= 1 ? this.getTierMaxCraftAmount() : (this.attemptAmount /= 2);
                }
                ++this.slot;
                if (this.slot >= this.itemFilter.getSlots()) {
                    this.slot = 0;
                }
            }
            if (this.type == 1) {
                while (this.slot < this.fluidFilter.getSlots() && this.fluidFilter.getFluid(this.slot).isEmpty()) {
                    ++this.slot;
                }
                if (this.slot >= this.fluidFilter.getSlots()) {
                    this.slot = 0;
                }
                if (!(filter = this.fluidFilter.getFluid(this.slot)).isEmpty()) {
                    current = this.network.extractFluid((FluidStack)filter, this.amount, Action.SIMULATE);
                    if (current.isEmpty() || current.getAmount() < this.amount) {
                        int n = count = current.isEmpty() ? this.amount : this.amount - current.getAmount();
                        if (count > 0) {
                            this.craftingTask = this.network.getCraftingManager().request((Object)this, (FluidStack)filter, count);
                            this.isMissingItems = true;
                        }
                    } else {
                        this.isMissingItems = false;
                    }
                }
                if (this.attemptAmount > this.amount) {
                    this.attemptAmount = this.amount;
                }
                if (this.slot == 0) {
                    this.attemptAmount = this.attemptAmount <= 1 ? this.getTierMaxCraftAmount() : (this.attemptAmount /= 2);
                }
                ++this.slot;
                if (this.slot >= this.fluidFilter.getSlots()) {
                    this.slot = 0;
                }
            }
        }
    }

    private int getTierMaxCraftAmount() {
        if (this.getTier() == CableTier.CREATIVE) {
            return Integer.MAX_VALUE;
        }
        if (this.getTier() == CableTier.ULTRA) {
            return (Integer)CableConfig.ULTRA_REQUESTER_MAX_CRAFT_AMOUNT.get();
        }
        if (this.getTier() == CableTier.ELITE) {
            return (Integer)CableConfig.ELITE_REQUESTER_MAX_CRAFT_AMOUNT.get();
        }
        return 0;
    }

    public int getType() {
        return this.level.f_46443_ ? (Integer)TieredRequesterBlockEntity.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.markDirty();
    }

    public boolean isMissingItems() {
        return this.isMissingItems && this.craftingTask == null;
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilter;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilter;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        StackUtils.readItems((BaseItemHandler)this.itemFilter, (int)0, (CompoundTag)tag);
        if (tag.m_128441_(NBT_AMOUNT)) {
            this.amount = tag.m_128451_(NBT_AMOUNT);
        }
        if (tag.m_128441_(NBT_MISSING)) {
            this.isMissingItems = tag.m_128471_(NBT_MISSING);
        }
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.itemFilter, (int)0, (CompoundTag)tag);
        tag.m_128405_(NBT_AMOUNT, this.amount);
        tag.m_128379_(NBT_MISSING, this.isMissingItems);
        return tag;
    }

    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128405_(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilter, (int)0, (CompoundTag)tag);
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilter.writeToNbt());
        tag.m_128405_(NBT_AMOUNT, this.amount);
        tag.m_128379_(NBT_MISSING, this.isMissingItems);
        return tag;
    }

    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_TYPE)) {
            this.type = tag.m_128451_(NBT_TYPE);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilter, (int)0, (CompoundTag)tag);
        if (tag.m_128441_(NBT_FLUID_FILTERS)) {
            this.fluidFilter.readFromNbt(tag.m_128469_(NBT_FLUID_FILTERS));
        }
        if (tag.m_128441_(NBT_AMOUNT)) {
            this.amount = tag.m_128451_(NBT_AMOUNT);
        }
        if (tag.m_128441_(NBT_MISSING)) {
            this.isMissingItems = tag.m_128471_(NBT_MISSING);
        }
    }
}

